/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionKey;
import com.intellij.psi.controlFlow.InstructionKeySet;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.Queue;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefUseUtil {
    private static final Logger LOG = Logger.getInstance(DefUseUtil.class);
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr == null) {
                3.$$$reportNull$$$0(0);
            }
            if (refExpr.isQualified()) {
                return null;
            }
            PsiElement refElement = refExpr.resolve();
            if (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) {
                return (PsiVariable)refElement;
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            if (psiParameter == null) {
                3.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            if (psiVariable == null) {
                3.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refExpr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiParameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiVariable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/controlFlow/DefUseUtil$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUsedVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isParameterAccepted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLocalVariableAccepted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private DefUseUtil() {
    }

    @Nullable
    public static List<Info> getUnusedDefs(PsiCodeBlock body2, Set<? super PsiVariable> outUsedVariables) {
        Map<InstructionKey, InstructionState> stateMap;
        ControlFlow flow;
        if (body2 == null) {
            return null;
        }
        try {
            flow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow((PsiElement)body2, ourPolicy, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        List<Instruction> instructions = flow.getInstructions();
        if (LOG.isDebugEnabled()) {
            LOG.debug(flow.toString());
        }
        THashSet assignedVariables = new THashSet();
        THashSet readVariables = new THashSet();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            ProgressManager.checkCanceled();
            if (instruction instanceof WriteVariableInstruction) {
                WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                PsiElement context = flow.getElement(i);
                context = PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
                PsiVariable psiVariable = writeInstruction.variable;
                if (context == null || context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) continue;
                assignedVariables.add(psiVariable);
                continue;
            }
            if (!(instruction instanceof ReadVariableInstruction)) continue;
            ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
            readVariables.add(readInstruction.variable);
        }
        try {
            stateMap = InstructionStateWalker.getStates(instructions);
        }
        catch (InstructionKey.OverflowException e) {
            LOG.error("Failed to compute paths in the control flow graph", (Throwable)e, new String[]{flow.toString()});
            return null;
        }
        Object[] states = stateMap.values().toArray(new InstructionState[0]);
        Arrays.sort(states);
        BitSet usefulWrites = new BitSet(instructions.size());
        Queue queue = new Queue(8);
        for (int i = states.length - 1; i >= 0; --i) {
            Object outerState = states[i];
            if (((InstructionState)outerState).isVisited()) continue;
            ((InstructionState)outerState).touch();
            for (PsiVariable psiVariable : assignedVariables) {
                if (!(psiVariable instanceof PsiField)) continue;
                ((InstructionState)outerState).addUsed(psiVariable);
            }
            queue.addLast(outerState);
            while (!queue.isEmpty()) {
                ProgressManager.checkCanceled();
                InstructionState state = (InstructionState)queue.pullFirst();
                state.markVisited();
                InstructionKey key2 = state.getInstructionKey();
                if (key2.getOffset() < instructions.size()) {
                    Instruction instruction = instructions.get(key2.getOffset());
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
                        PsiVariable psiVariable = writeInstruction.variable;
                        outUsedVariables.add((PsiVariable)psiVariable);
                        if (state.removeUsed(psiVariable)) {
                            usefulWrites.set(key2.getOffset());
                        }
                    } else if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction readInstruction = (ReadVariableInstruction)instruction;
                        state.addUsed(readInstruction.variable);
                        outUsedVariables.add((PsiVariable)readInstruction.variable);
                    } else {
                        state.touch();
                    }
                }
                List<InstructionKey> backwardTraces = state.getBackwardTraces();
                for (InstructionKey prevKeys : backwardTraces) {
                    InstructionState prevState = stateMap.get(prevKeys);
                    if (prevState == null || prevState.contains(state)) continue;
                    prevState.addUsedFrom(state);
                    queue.addLast((Object)prevState);
                }
            }
        }
        ArrayList<Info> unusedDefs = new ArrayList<Info>();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction)) continue;
            WriteVariableInstruction writeInstruction = (WriteVariableInstruction)instruction;
            if (usefulWrites.get(i)) continue;
            PsiElement context = PsiTreeUtil.getNonStrictParentOfType((PsiElement)flow.getElement(i), (Class[])new Class[]{PsiStatement.class, PsiAssignmentExpression.class, PsiUnaryExpression.class});
            PsiVariable psiVariable = writeInstruction.variable;
            if (context == null || context instanceof PsiTryStatement) continue;
            if (context instanceof PsiDeclarationStatement && psiVariable.getInitializer() == null) {
                if (assignedVariables.contains(psiVariable)) continue;
                unusedDefs.add(new Info(psiVariable, context, false));
                continue;
            }
            unusedDefs.add(new Info(psiVariable, context, readVariables.contains(psiVariable)));
        }
        return unusedDefs;
    }

    public static PsiElement @NotNull [] getDefs(@NotNull PsiCodeBlock body2, @NotNull PsiVariable def, @NotNull PsiElement ref) {
        if (body2 == null) {
            DefUseUtil.$$$reportNull$$$0(0);
        }
        if (def == null) {
            DefUseUtil.$$$reportNull$$$0(1);
        }
        if (ref == null) {
            DefUseUtil.$$$reportNull$$$0(2);
        }
        return DefUseUtil.getDefs(body2, def, ref, false);
    }

    public static PsiElement @NotNull [] getDefs(@NotNull PsiCodeBlock body2, final @NotNull PsiVariable def, @NotNull PsiElement ref, boolean rethrow) {
        PsiElement[] psiElementArray;
        if (body2 == null) {
            DefUseUtil.$$$reportNull$$$0(3);
        }
        if (def == null) {
            DefUseUtil.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            DefUseUtil.$$$reportNull$$$0(5);
        }
        try {
            RefsDefs refsDefs = new RefsDefs(body2){
                private final IntArrayList[] myBackwardTraces;
                {
                    super(body2);
                    this.myBackwardTraces = DefUseUtil.getBackwardTraces(this.instructions);
                }

                @Override
                protected int nNext(int index) {
                    return this.myBackwardTraces[index].size();
                }

                @Override
                protected int getNext(int index, int no) {
                    return this.myBackwardTraces[index].get(no);
                }

                @Override
                protected boolean defs() {
                    return true;
                }

                @Override
                protected void processInstruction(final @NotNull Set<? super PsiElement> res, @NotNull Instruction instruction, int index) {
                    if (res == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (instruction == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                        if (instructionW.variable == def) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (PsiUtil.isAccessedForWriting((PsiExpression)ref) && ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }

                                public void visitVariable(PsiVariable var) {
                                    if (var == def && (var instanceof PsiParameter || var.hasInitializer())) {
                                        res.add(var);
                                    }
                                }
                            });
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "res";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "instruction";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/psi/controlFlow/DefUseUtil$1";
                    objectArray[2] = "processInstruction";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            psiElementArray = refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (rethrow) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                DefUseUtil.$$$reportNull$$$0(7);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (psiElementArray == null) {
            DefUseUtil.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    public static PsiElement @NotNull [] getRefs(@NotNull PsiCodeBlock body2, @NotNull PsiVariable def, @NotNull PsiElement ref) {
        if (body2 == null) {
            DefUseUtil.$$$reportNull$$$0(8);
        }
        if (def == null) {
            DefUseUtil.$$$reportNull$$$0(9);
        }
        if (ref == null) {
            DefUseUtil.$$$reportNull$$$0(10);
        }
        PsiElement[] psiElementArray = DefUseUtil.getRefs(body2, def, ref, false);
        if (psiElementArray == null) {
            DefUseUtil.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    public static PsiElement[] getRefs(@NotNull PsiCodeBlock body2, final @NotNull PsiVariable def, @NotNull PsiElement ref, boolean rethrow) {
        if (body2 == null) {
            DefUseUtil.$$$reportNull$$$0(12);
        }
        if (def == null) {
            DefUseUtil.$$$reportNull$$$0(13);
        }
        if (ref == null) {
            DefUseUtil.$$$reportNull$$$0(14);
        }
        try {
            RefsDefs refsDefs = new RefsDefs(body2){

                @Override
                protected int nNext(int index) {
                    return ((Instruction)this.instructions.get(index)).nNext();
                }

                @Override
                protected int getNext(int index, int no) {
                    return ((Instruction)this.instructions.get(index)).getNext(index, no);
                }

                @Override
                protected boolean defs() {
                    return false;
                }

                @Override
                protected void processInstruction(final @NotNull Set<? super PsiElement> res, @NotNull Instruction instruction, int index) {
                    if (res == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (instruction == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction instructionR = (ReadVariableInstruction)instruction;
                        if (instructionR.variable == def) {
                            PsiElement element = this.flow.getElement(index);
                            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                                public void visitReferenceExpression(PsiReferenceExpression ref) {
                                    if (ref.resolve() == def) {
                                        res.add(ref);
                                    }
                                }
                            });
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "res";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "instruction";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/psi/controlFlow/DefUseUtil$2";
                    objectArray[2] = "processInstruction";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            return refsDefs.get(def, ref);
        }
        catch (AnalysisCanceledException e) {
            if (rethrow) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
            return PsiElement.EMPTY_ARRAY;
        }
    }

    private static IntArrayList @NotNull [] getBackwardTraces(@NotNull List<? extends Instruction> instructions) {
        int i;
        if (instructions == null) {
            DefUseUtil.$$$reportNull$$$0(15);
        }
        IntArrayList[] states = new IntArrayList[instructions.size()];
        for (i = 0; i < states.length; ++i) {
            states[i] = new IntArrayList();
        }
        for (i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            for (int j = 0; j != instruction.nNext(); ++j) {
                int next = instruction.getNext(i, j);
                if (next >= states.length) continue;
                states[next].add(i);
            }
        }
        if (states == null) {
            DefUseUtil.$$$reportNull$$$0(16);
        }
        return states;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/DefUseUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/DefUseUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackwardTraces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefs";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 16: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRefs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBackwardTraces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InstructionStateWalker {
        private final Map<InstructionKey, InstructionState> myStates;
        private final WalkThroughStack myWalkThroughStack;
        private final List<? extends Instruction> myInstructions;

        private InstructionStateWalker(@NotNull List<? extends Instruction> instructions) {
            if (instructions == null) {
                InstructionStateWalker.$$$reportNull$$$0(0);
            }
            this.myStates = new THashMap(instructions.size());
            this.myWalkThroughStack = new WalkThroughStack(instructions.size() / 2);
            this.myInstructions = instructions;
        }

        @NotNull
        private Map<InstructionKey, InstructionState> walk() {
            InstructionKey startKey = InstructionKey.create(0);
            this.myStates.put(startKey, new InstructionState(startKey));
            this.myWalkThroughStack.push(InstructionKey.create(-1), startKey);
            InstructionKeySet visited = new InstructionKeySet(this.myInstructions.size() + 1);
            while (!this.myWalkThroughStack.isEmpty()) {
                ProgressManager.checkCanceled();
                InstructionKey fromKey = this.myWalkThroughStack.peekFrom();
                InstructionKey nextKey = this.myWalkThroughStack.popNext();
                this.addBackwardTrace(fromKey, nextKey);
                if (visited.contains(nextKey)) continue;
                this.visit(nextKey);
                visited.add(nextKey);
            }
            Map<InstructionKey, InstructionState> map2 = this.myStates;
            if (map2 == null) {
                InstructionStateWalker.$$$reportNull$$$0(1);
            }
            return map2;
        }

        private void visit(@NotNull InstructionKey fromKey) {
            if (fromKey == null) {
                InstructionStateWalker.$$$reportNull$$$0(2);
            }
            if (fromKey.getOffset() >= this.myInstructions.size()) {
                return;
            }
            Instruction instruction = this.myInstructions.get(fromKey.getOffset());
            if (instruction instanceof CallInstruction) {
                int nextOffset = ((CallInstruction)instruction).offset;
                LOG.assertTrue(nextOffset != 0);
                int returnOffset = fromKey.getOffset() + 1;
                InstructionKey nextKey = fromKey.push(nextOffset, returnOffset);
                this.myWalkThroughStack.push(fromKey, nextKey);
            } else if (instruction instanceof ReturnInstruction) {
                int overriddenOffset = ((ReturnInstruction)instruction).offset;
                InstructionKey nextKey = fromKey.pop(overriddenOffset);
                this.myWalkThroughStack.push(fromKey, nextKey);
            } else {
                for (int no = 0; no != instruction.nNext(); ++no) {
                    int nextOffset = instruction.getNext(fromKey.getOffset(), no);
                    InstructionKey nextKey = fromKey.next(nextOffset);
                    this.myWalkThroughStack.push(fromKey, nextKey);
                }
            }
        }

        private void addBackwardTrace(@NotNull InstructionKey fromKey, @NotNull InstructionKey nextKey) {
            if (fromKey == null) {
                InstructionStateWalker.$$$reportNull$$$0(3);
            }
            if (nextKey == null) {
                InstructionStateWalker.$$$reportNull$$$0(4);
            }
            if (fromKey.getOffset() >= 0 && nextKey.getOffset() < this.myInstructions.size()) {
                InstructionState state = this.myStates.get(nextKey);
                if (state == null) {
                    state = new InstructionState(nextKey);
                    this.myStates.put(nextKey, state);
                }
                state.addBackwardTrace(fromKey);
            }
        }

        @NotNull
        static Map<InstructionKey, InstructionState> getStates(@NotNull List<? extends Instruction> instructions) {
            if (instructions == null) {
                InstructionStateWalker.$$$reportNull$$$0(5);
            }
            return new InstructionStateWalker(instructions).walk();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/DefUseUtil$InstructionStateWalker";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromKey";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nextKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/DefUseUtil$InstructionStateWalker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "walk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addBackwardTrace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getStates";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WalkThroughStack {
        private final Stack<InstructionKey> myFrom;
        private final Stack<InstructionKey> myNext;

        WalkThroughStack(int size) {
            if (size < 2) {
                size = 2;
            }
            this.myFrom = new Stack(size);
            this.myNext = new Stack(size);
        }

        void push(@NotNull InstructionKey fromKey, @NotNull InstructionKey nextKey) {
            if (fromKey == null) {
                WalkThroughStack.$$$reportNull$$$0(0);
            }
            if (nextKey == null) {
                WalkThroughStack.$$$reportNull$$$0(1);
            }
            this.myFrom.push((Object)fromKey);
            this.myNext.push((Object)nextKey);
        }

        @NotNull
        InstructionKey peekFrom() {
            InstructionKey instructionKey = (InstructionKey)this.myFrom.peek();
            if (instructionKey == null) {
                WalkThroughStack.$$$reportNull$$$0(2);
            }
            return instructionKey;
        }

        @NotNull
        InstructionKey popNext() {
            this.myFrom.pop();
            InstructionKey instructionKey = (InstructionKey)this.myNext.pop();
            if (instructionKey == null) {
                WalkThroughStack.$$$reportNull$$$0(3);
            }
            return instructionKey;
        }

        boolean isEmpty() {
            return this.myFrom.isEmpty();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int limit = Math.min(this.myFrom.size(), this.myNext.size());
            for (int i = 0; i < limit; ++i) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(this.myFrom.get(i)).append("->").append(this.myNext.get(i));
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nextKey";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/DefUseUtil$WalkThroughStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/DefUseUtil$WalkThroughStack";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "peekFrom";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "popNext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "push";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class RefsDefs {
        @NotNull
        final List<Instruction> instructions;
        final ControlFlow flow;
        final PsiCodeBlock body;

        protected abstract int nNext(int var1);

        protected abstract int getNext(int var1, int var2);

        RefsDefs(@NotNull PsiCodeBlock body2) throws AnalysisCanceledException {
            if (body2 == null) {
                RefsDefs.$$$reportNull$$$0(0);
            }
            this.body = body2;
            this.flow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow((PsiElement)body2, ourPolicy, false, false);
            this.instructions = this.flow.getInstructions();
        }

        protected abstract void processInstruction(@NotNull Set<? super PsiElement> var1, @NotNull Instruction var2, int var3);

        protected abstract boolean defs();

        private PsiElement @NotNull [] get(@NotNull PsiVariable def, @NotNull PsiElement refOrDef) {
            int elem;
            if (def == null) {
                RefsDefs.$$$reportNull$$$0(1);
            }
            if (refOrDef == null) {
                RefsDefs.$$$reportNull$$$0(2);
            }
            if (this.body == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    RefsDefs.$$$reportNull$$$0(3);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            final boolean[] visited = new boolean[this.instructions.size() + 1];
            visited[visited.length - 1] = true;
            int n = elem = this.defs() ? this.flow.getStartOffset(refOrDef) : this.flow.getEndOffset(refOrDef);
            if (elem == -1 && def instanceof PsiParameter) {
                elem = 0;
            }
            if (elem != -1) {
                if (!this.defs() && this.instructions.get(elem) instanceof ReadVariableInstruction) {
                    LOG.assertTrue(this.nNext(elem) == 1);
                    LOG.assertTrue(this.getNext(elem, 0) == elem + 1);
                    ++elem;
                }
                THashSet res = new THashSet();
                class Inner {
                    final /* synthetic */ Set val$res;
                    final /* synthetic */ PsiVariable val$def;

                    Inner() {
                        this.val$res = set;
                        this.val$def = psiVariable;
                    }

                    private void traverse(int index) {
                        if (visited[index]) {
                            return;
                        }
                        visited[index] = true;
                        if (RefsDefs.this.defs()) {
                            Instruction instruction = RefsDefs.this.instructions.get(index);
                            RefsDefs.this.processInstruction(this.val$res, instruction, index);
                            if (instruction instanceof WriteVariableInstruction) {
                                WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                if (instructionW.variable == this.val$def) {
                                    return;
                                }
                            }
                            if (index == 0 && this.val$def instanceof PsiParameter) {
                                this.val$res.add(this.val$def.getNameIdentifier());
                            }
                        }
                        int nNext = RefsDefs.this.nNext(index);
                        for (int i = 0; i < nNext; ++i) {
                            int prev = RefsDefs.this.getNext(index, i);
                            if (visited[prev]) continue;
                            if (!RefsDefs.this.defs()) {
                                Instruction instruction = RefsDefs.this.instructions.get(prev);
                                if (instruction instanceof WriteVariableInstruction) {
                                    WriteVariableInstruction instructionW = (WriteVariableInstruction)instruction;
                                    if (instructionW.variable == this.val$def) {
                                        continue;
                                    }
                                } else {
                                    RefsDefs.this.processInstruction(this.val$res, instruction, prev);
                                }
                            }
                            this.traverse(prev);
                        }
                    }
                }
                new Inner().traverse(elem);
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)res);
                if (psiElementArray == null) {
                    RefsDefs.$$$reportNull$$$0(4);
                }
                return psiElementArray;
            }
            if (PsiElement.EMPTY_ARRAY == null) {
                RefsDefs.$$$reportNull$$$0(5);
            }
            return PsiElement.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "def";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refOrDef";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/DefUseUtil$RefsDefs";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InstructionState
    implements Comparable<InstructionState> {
        private Set<PsiVariable> myUsed;
        @NotNull
        private final InstructionKey myInstructionKey;
        private final List<InstructionKey> myBackwardTraces;
        private boolean myIsVisited;

        InstructionState(@NotNull InstructionKey instructionKey) {
            if (instructionKey == null) {
                InstructionState.$$$reportNull$$$0(0);
            }
            this.myInstructionKey = instructionKey;
            this.myBackwardTraces = new ArrayList<InstructionKey>(2);
            this.myUsed = null;
        }

        void addBackwardTrace(@NotNull InstructionKey key2) {
            if (key2 == null) {
                InstructionState.$$$reportNull$$$0(1);
            }
            this.myBackwardTraces.add(key2);
        }

        @NotNull
        List<InstructionKey> getBackwardTraces() {
            List<InstructionKey> list = this.myBackwardTraces;
            if (list == null) {
                InstructionState.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        InstructionKey getInstructionKey() {
            InstructionKey instructionKey = this.myInstructionKey;
            if (instructionKey == null) {
                InstructionState.$$$reportNull$$$0(3);
            }
            return instructionKey;
        }

        void addUsed(@NotNull PsiVariable psiVariable) {
            if (psiVariable == null) {
                InstructionState.$$$reportNull$$$0(4);
            }
            this.touch();
            this.myUsed.add(psiVariable);
        }

        boolean removeUsed(PsiVariable psiVariable) {
            this.touch();
            return this.myUsed.remove(psiVariable);
        }

        private void touch() {
            if (this.myUsed == null) {
                this.myUsed = new THashSet();
            }
        }

        void addUsedFrom(InstructionState state) {
            this.touch();
            this.myUsed.addAll(state.myUsed);
        }

        public boolean contains(InstructionState state) {
            return this.myUsed != null && state.myUsed != null && this.myUsed.containsAll(state.myUsed);
        }

        void markVisited() {
            this.myIsVisited = true;
        }

        public boolean isVisited() {
            return this.myIsVisited;
        }

        @Override
        public int compareTo(@NotNull InstructionState other) {
            if (other == null) {
                InstructionState.$$$reportNull$$$0(5);
            }
            return this.myInstructionKey.compareTo(other.myInstructionKey);
        }

        public String toString() {
            return this.myInstructionKey + " " + this.myBackwardTraces + (this.myIsVisited ? "(v)" : "(n)") + " " + (this.myUsed != null ? this.myUsed : "-");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructionKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/DefUseUtil$InstructionState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiVariable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/DefUseUtil$InstructionState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackwardTraces";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstructionKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addBackwardTrace";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addUsed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Info {
        @NotNull
        private final PsiVariable myVariable;
        @NotNull
        private final PsiElement myContext;
        private final boolean myIsRead;

        public Info(@NotNull PsiVariable variable, @NotNull PsiElement context, boolean read2) {
            if (variable == null) {
                Info.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Info.$$$reportNull$$$0(1);
            }
            this.myVariable = variable;
            this.myContext = context;
            this.myIsRead = read2;
        }

        @NotNull
        public PsiVariable getVariable() {
            PsiVariable psiVariable = this.myVariable;
            if (psiVariable == null) {
                Info.$$$reportNull$$$0(2);
            }
            return psiVariable;
        }

        @NotNull
        public PsiElement getContext() {
            PsiElement psiElement = this.myContext;
            if (psiElement == null) {
                Info.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        public boolean isRead() {
            return this.myIsRead;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/DefUseUtil$Info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/DefUseUtil$Info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

