/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.impl.java.stubs.index.JavaStaticMemberTypeIndex;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MembersGetter {
    public static final Key<Boolean> EXPECTED_TYPE_MEMBER = Key.create((String)"EXPECTED_TYPE_MEMBER");
    private final Set<PsiMember> myImportedStatically;
    private final List<PsiClass> myPlaceClasses;
    private final List<PsiMethod> myPlaceMethods;
    protected final PsiElement myPlace;

    protected MembersGetter(StaticMemberProcessor processor, @NotNull PsiElement place) {
        if (place == null) {
            MembersGetter.$$$reportNull$$$0(0);
        }
        this.myImportedStatically = new HashSet<PsiMember>();
        this.myPlaceClasses = new ArrayList<PsiClass>();
        this.myPlaceMethods = new ArrayList<PsiMethod>();
        this.myPlace = place;
        processor.processMembersOfRegisteredClasses(PrefixMatcher.ALWAYS_TRUE, (PairConsumer<? super PsiMember, ? super PsiClass>)((PairConsumer)(member, psiClass) -> this.myImportedStatically.add((PsiMember)member)));
        PsiClass current = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PsiClass.class});
        while (current != null) {
            current = (PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)current);
            this.myPlaceClasses.add(current);
            current = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)current, (Class[])new Class[]{PsiClass.class});
        }
        PsiMethod eachMethod = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PsiMethod.class});
        while (eachMethod != null) {
            eachMethod = (PsiMethod)CompletionUtil.getOriginalOrSelf((PsiElement)eachMethod);
            this.myPlaceMethods.add(eachMethod);
            eachMethod = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)eachMethod, (Class[])new Class[]{PsiMethod.class});
        }
    }

    private boolean mayProcessMembers(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        for (PsiClass placeClass : this.myPlaceClasses) {
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)placeClass, (PsiClass)psiClass, (boolean)true)) continue;
            return false;
        }
        return true;
    }

    public void processMembers(Consumer<? super LookupElement> results, @Nullable PsiClass where, boolean acceptMethods, boolean searchInheritors) {
        if (where == null || MembersGetter.isPrimitiveClass(where)) {
            return;
        }
        boolean searchFactoryMethods = searchInheritors && !"java.lang.Object".equals(where.getQualifiedName()) && !MembersGetter.isPrimitiveClass(where);
        Project project = this.myPlace.getProject();
        GlobalSearchScope scope = this.myPlace.getResolveScope();
        PsiClassType baseType = JavaPsiFacade.getElementFactory((Project)project).createType(where);
        Consumer consumer = psiType -> {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
            if (psiClass == null) {
                return;
            }
            if (this.mayProcessMembers(psiClass = (PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)psiClass))) {
                FilterScopeProcessor declProcessor = new FilterScopeProcessor(TrueFilter.INSTANCE);
                psiClass.processDeclarations(declProcessor, ResolveState.initial(), null, this.myPlace);
                this.doProcessMembers(acceptMethods, results, psiType == baseType, declProcessor.getResults());
                String name2 = psiClass.getName();
                if (name2 != null && searchFactoryMethods) {
                    Collection<PsiMember> factoryMethods = JavaStaticMemberTypeIndex.getInstance().getStaticMembers(name2, project, scope);
                    this.doProcessMembers(acceptMethods, results, false, factoryMethods);
                }
            }
        };
        consumer.consume((Object)baseType);
        if (searchInheritors && !"java.lang.Object".equals(where.getQualifiedName())) {
            CodeInsightUtil.processSubTypes((PsiType)baseType, this.myPlace, true, PrefixMatcher.ALWAYS_TRUE, (Consumer<? super PsiType>)consumer);
        }
    }

    private static boolean isPrimitiveClass(PsiClass where) {
        String qname = where.getQualifiedName();
        if (qname == null || !qname.startsWith("java.lang.")) {
            return false;
        }
        return "java.lang.String".equals(qname) || InheritanceUtil.isInheritor((PsiClass)where, (String)"java.lang.Number");
    }

    private void doProcessMembers(boolean acceptMethods, Consumer<? super LookupElement> results, boolean isExpectedTypeMember, Collection<? extends PsiElement> declarations) {
        for (PsiElement psiElement : declarations) {
            LookupElement item;
            PsiMember member;
            if (!(psiElement instanceof PsiMember) || psiElement instanceof PsiClass || !(member = (PsiMember)psiElement).hasModifierProperty("static") || psiElement instanceof PsiField && !member.hasModifierProperty("final") || psiElement instanceof PsiMethod && (!acceptMethods || this.myPlaceMethods.contains(psiElement)) || JavaCompletionUtil.isInExcludedPackage(member, false) || this.myImportedStatically.contains(member) || !JavaPsiFacade.getInstance((Project)this.myPlace.getProject()).getResolveHelper().isAccessible(member, this.myPlace, null) || (item = psiElement instanceof PsiMethod ? this.createMethodElement((PsiMethod)psiElement) : this.createFieldElement((PsiField)psiElement)) == null) continue;
            item.putUserData(EXPECTED_TYPE_MEMBER, (Object)isExpectedTypeMember);
            results.consume((Object)AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(item));
        }
    }

    @Nullable
    protected abstract LookupElement createFieldElement(PsiField var1);

    @Nullable
    protected abstract LookupElement createMethodElement(PsiMethod var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/filters/getters/MembersGetter", "<init>"));
    }
}

