/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.TextLineBlock;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/psi/formatter/java/CStyleCommentBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "comment", "Lcom/intellij/lang/ASTNode;", "indent", "Lcom/intellij/formatting/Indent;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/Indent;)V", "ranges", "", "Lcom/intellij/openapi/util/TextRange;", "getRanges", "()Ljava/util/List;", "ranges$delegate", "Lkotlin/Lazy;", "spacing", "Lcom/intellij/formatting/Spacing;", "getSpacing", "()Lcom/intellij/formatting/Spacing;", "buildChildren", "Lcom/intellij/formatting/Block;", "getIndent", "child1", "child2", "isLeaf", "", "skipBackAndUp", "node", "intellij.java.impl"})
public final class CStyleCommentBlock
extends AbstractBlock {
    private final Lazy ranges$delegate;
    private final Indent indent;

    @Nullable
    public final Spacing getSpacing() {
        return this.getRanges().isEmpty() ? Spacing.getReadOnlySpacing() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)child2, (String)"child2");
        if (child1 == null) {
            ASTNode aSTNode = this.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
            if (this.skipBackAndUp(aSTNode) == null) {
                spacing = Spacing.getReadOnlySpacing();
                return spacing;
            }
        }
        spacing = child2.getSpacing(null, (Block)this);
        return spacing;
    }

    private final ASTNode skipBackAndUp(ASTNode node) {
        ASTNode aSTNode;
        ASTNode prev = TreeUtil.skipElementsBack((ASTNode)node.getTreePrev(), (TokenSet)TokenSet.WHITE_SPACE);
        if (prev == null && node.getTreeParent() != null) {
            ASTNode aSTNode2 = node.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"node.treeParent");
            aSTNode = this.skipBackAndUp(aSTNode2);
        } else {
            aSTNode = prev;
        }
        return aSTNode;
    }

    @Nullable
    public Indent getIndent() {
        return this.indent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<Block> buildChildren() {
        List<TextRange> ranges2 = this.getRanges();
        if (ranges2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList children = new ArrayList(ranges2.size());
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
        int nodeStart = aSTNode.getStartOffset();
        int n = 0;
        int n2 = ((Collection)ranges2).size();
        while (n < n2) {
            void i;
            Indent indent = i == false ? Indent.getNoneIndent() : Indent.getSpaceIndent((int)1);
            Collection collection = children;
            TextRange textRange = ranges2.get((int)i).shiftRight(nodeStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"ranges[i].shiftRight(nodeStart)");
            TextLineBlock textLineBlock = new TextLineBlock(textRange, null, indent, null);
            boolean bl = false;
            collection.add(textLineBlock);
            ++i;
        }
        return children;
    }

    public boolean isLeaf() {
        return this.getRanges().isEmpty();
    }

    private final List<TextRange> getRanges() {
        Lazy lazy = this.ranges$delegate;
        CStyleCommentBlock cStyleCommentBlock = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public CStyleCommentBlock(@NotNull ASTNode comment, @Nullable Indent indent) {
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        super(comment, null, null);
        this.indent = indent;
        this.ranges$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends TextRange>>(this){
            final /* synthetic */ CStyleCommentBlock this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<TextRange> invoke() {
                void var2_3;
                ASTNode aSTNode = this.this$0.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
                CharSequence charSequence = aSTNode.getChars();
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"node.chars");
                CharSequence text2 = charSequence;
                if (!StringsKt.startsWith$default((CharSequence)text2, (CharSequence)"/*", (boolean)false, (int)2, null)) {
                    return CollectionsKt.emptyList();
                }
                boolean bl = false;
                List result = new ArrayList<E>();
                int start = 0;
                int n = 2;
                int n2 = text2.length();
                while (n < n2) {
                    Object object;
                    void i;
                    char c = text2.charAt((int)i);
                    if (start < 0) {
                        if (!Character.isWhitespace(c)) {
                            if (c != '*') {
                                return CollectionsKt.emptyList();
                            }
                            start = i;
                        }
                    } else if (i == text2.length() - 1) {
                        Collection collection = result;
                        object = new TextRange(start, text2.length());
                        boolean bl2 = false;
                        collection.add(object);
                    } else if (c == '\n') {
                        void end = i - true;
                        while (Character.isWhitespace(text2.charAt((int)end))) {
                            --end;
                        }
                        object = result;
                        TextRange textRange = new TextRange(start, (int)(end + true));
                        boolean bl3 = false;
                        object.add(textRange);
                        start = -1;
                    }
                    ++i;
                }
                return var2_3;
            }
            {
                this.this$0 = cStyleCommentBlock;
                super(0);
            }
        }));
    }
}

