/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import org.intellij.lang.regexp.AsciiUtil;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRegExpHost
implements RegExpLanguageHost {
    protected static final EnumSet<RegExpGroup.Type> SUPPORTED_NAMED_GROUP_TYPES = EnumSet.of(RegExpGroup.Type.NAMED_GROUP);
    private final DefaultRegExpPropertiesProvider myPropertiesProvider;
    private static final int myNumberOfGeneralCategoryProperties = 58;
    private final String[][] myPropertyNames = new String[][]{{"Cn", "Unassigned"}, {"Lu", "Uppercase letter"}, {"Ll", "Lowercase letter"}, {"Lt", "Titlecase letter"}, {"Lm", "Modifier letter"}, {"Lo", "Other letter"}, {"Mn", "Non spacing mark"}, {"Me", "Enclosing mark"}, {"Mc", "Combining spacing mark"}, {"Nd", "Decimal digit number"}, {"Nl", "Letter number"}, {"No", "Other number"}, {"Zs", "Space separator"}, {"Zl", "Line separator"}, {"Zp", "Paragraph separator"}, {"Cc", "Control"}, {"Cf", "Format"}, {"Co", "Private use"}, {"Cs", "Surrogate"}, {"Pd", "Dash punctuation"}, {"Ps", "Start punctuation"}, {"Pe", "End punctuation"}, {"Pc", "Connector punctuation"}, {"Po", "Other punctuation"}, {"Sm", "Math symbol"}, {"Sc", "Currency symbol"}, {"Sk", "Modifier symbol"}, {"So", "Other symbol"}, {"Pi", "Initial quote punctuation"}, {"Pf", "Final quote punctuation"}, {"L", "Letter"}, {"M", "Mark"}, {"N", "Number"}, {"Z", "Separator"}, {"C", "Control"}, {"P", "Punctuation"}, {"S", "Symbol"}, {"LC", "Letter"}, {"LD", "Letter or digit"}, {"L1", "Latin-1"}, {"all", "All"}, {"javaLowerCase"}, {"javaUpperCase"}, {"javaTitleCase"}, {"javaAlphabetic"}, {"javaIdeographic"}, {"javaDigit"}, {"javaDefined"}, {"javaLetter"}, {"javaLetterOrDigit"}, {"javaJavaIdentifierStart"}, {"javaJavaIdentifierPart"}, {"javaUnicodeIdentifierStart"}, {"javaUnicodeIdentifierPart"}, {"javaIdentifierIgnorable"}, {"javaSpaceChar"}, {"javaWhitespace"}, {"javaISOControl"}, {"javaMirrored"}, {"ASCII", "Ascii"}, {"Alnum", "Alphanumeric characters"}, {"Alpha", "Alphabetic characters"}, {"Blank", "Space and tab characters"}, {"Cntrl", "Control characters"}, {"Digit", "Numeric characters"}, {"Graph", "Printable and visible"}, {"Lower", "Lowercase Alphabetic"}, {"Print", "Printable characters"}, {"Punct", "Punctuation characters"}, {"Space", "Space characters"}, {"Upper", "Uppercase alphabetic"}, {"XDigit", "Hexadecimal digits"}};

    public JavaRegExpHost() {
        this.myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();
    }

    public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        switch (flag) {
            case 'd': 
            case 'i': 
            case 'm': 
            case 's': 
            case 'u': 
            case 'x': {
                return true;
            }
            case 'U': {
                return JavaRegExpHost.hasAtLeastJdkVersion(context, JavaSdkVersion.JDK_1_7);
            }
        }
        return false;
    }

    public boolean characterNeedsEscaping(char c) {
        return false;
    }

    public boolean supportsNamedCharacters(RegExpNamedCharacter namedCharacter) {
        return JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)namedCharacter, JavaSdkVersion.JDK_1_9);
    }

    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    public boolean supportsPossessiveQuantifiers() {
        return true;
    }

    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        return group.getType() == RegExpGroup.Type.NAMED_GROUP && JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)group, JavaSdkVersion.JDK_1_7);
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        return ref.isNamedGroupRef() && JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)ref, JavaSdkVersion.JDK_1_7);
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        if (!JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)context, JavaSdkVersion.JDK_1_7)) {
            EnumSet enumSet = EMPTY_NAMED_GROUP_TYPES;
            if (enumSet == null) {
                JavaRegExpHost.$$$reportNull$$$0(0);
            }
            return enumSet;
        }
        EnumSet<RegExpGroup.Type> enumSet = SUPPORTED_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            JavaRegExpHost.$$$reportNull$$$0(1);
        }
        return enumSet;
    }

    public boolean isValidGroupName(String name2, @NotNull RegExpGroup group) {
        if (group == null) {
            JavaRegExpHost.$$$reportNull$$$0(2);
        }
        int length = name2.length();
        for (int i = 0; i < length; ++i) {
            char c = name2.charAt(i);
            if (AsciiUtil.isLetterOrDigit((char)c)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return regExpChar.getUnescapedText().charAt(1) == 'x' && JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)regExpChar, JavaSdkVersion.JDK_1_7);
    }

    public boolean supportsBoundary(RegExpBoundary boundary) {
        switch (boundary.getType()) {
            case UNICODE_EXTENDED_GRAPHEME: {
                return JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)boundary, JavaSdkVersion.JDK_1_9);
            }
            case RESET_MATCH: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsSimpleClass(RegExpSimpleClass simpleClass) {
        switch (simpleClass.getKind()) {
            case UNICODE_LINEBREAK: 
            case HORIZONTAL_SPACE: 
            case NON_HORIZONTAL_SPACE: 
            case NON_VERTICAL_SPACE: {
                return JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)simpleClass, JavaSdkVersion.JDK_1_8);
            }
            case VERTICAL_SPACE: {
                return true;
            }
            case UNICODE_GRAPHEME: {
                return JavaRegExpHost.hasAtLeastJdkVersion((PsiElement)simpleClass, JavaSdkVersion.JDK_1_9);
            }
            case XML_NAME_START: 
            case NON_XML_NAME_START: 
            case XML_NAME_PART: 
            case NON_XML_NAME_PART: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsLiteralBackspace(RegExpChar aChar) {
        return false;
    }

    private static boolean hasAtLeastJdkVersion(PsiElement element, JavaSdkVersion version) {
        return JavaRegExpHost.getJavaVersion(element).isAtLeast(version);
    }

    @NotNull
    private static JavaSdkVersion getJavaVersion(PsiElement element) {
        JavaSdkVersion version;
        Sdk sdk;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdk && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            JavaSdkVersion javaSdkVersion = version;
            if (javaSdkVersion == null) {
                JavaRegExpHost.$$$reportNull$$$0(3);
            }
            return javaSdkVersion;
        }
        JavaSdkVersion javaSdkVersion = JavaSdkVersion.JDK_1_9;
        if (javaSdkVersion == null) {
            JavaRegExpHost.$$$reportNull$$$0(4);
        }
        return javaSdkVersion;
    }

    public boolean isValidPropertyName(@NotNull String name2) {
        if (name2 == null) {
            JavaRegExpHost.$$$reportNull$$$0(5);
        }
        return JavaRegExpHost.isScriptProperty(name2) || JavaRegExpHost.isBlockProperty(name2) || JavaRegExpHost.isCategoryProperty(name2);
    }

    private static boolean isScriptProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            JavaRegExpHost.$$$reportNull$$$0(6);
        }
        return "script".equalsIgnoreCase(propertyName) || "sc".equalsIgnoreCase(propertyName);
    }

    private static boolean isBlockProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            JavaRegExpHost.$$$reportNull$$$0(7);
        }
        return "block".equalsIgnoreCase(propertyName) || "blk".equalsIgnoreCase(propertyName);
    }

    private static boolean isCategoryProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            JavaRegExpHost.$$$reportNull$$$0(8);
        }
        return "general_category".equalsIgnoreCase(propertyName) || "gc".equalsIgnoreCase(propertyName);
    }

    public boolean isValidPropertyValue(@NotNull String propertyName, @NotNull String value2) {
        if (propertyName == null) {
            JavaRegExpHost.$$$reportNull$$$0(9);
        }
        if (value2 == null) {
            JavaRegExpHost.$$$reportNull$$$0(10);
        }
        if (JavaRegExpHost.isScriptProperty(propertyName)) {
            return JavaRegExpHost.isValidUnicodeScript(value2);
        }
        if (JavaRegExpHost.isBlockProperty(propertyName)) {
            return JavaRegExpHost.isValidUnicodeBlock(value2);
        }
        if (JavaRegExpHost.isCategoryProperty(propertyName)) {
            return this.isValidGeneralCategory(value2);
        }
        return false;
    }

    public boolean isValidGeneralCategory(String value2) {
        for (int i = 0; i < 58; ++i) {
            if (!value2.equals(this.myPropertyNames[i][0])) continue;
            return true;
        }
        return false;
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            JavaRegExpHost.$$$reportNull$$$0(11);
        }
        if (category.startsWith("In")) {
            return JavaRegExpHost.isValidUnicodeBlock(category.substring(2));
        }
        if (category.startsWith("Is")) {
            if (this.isValidProperty(category = category.substring(2))) {
                return true;
            }
            switch (category = StringUtil.toUpperCase((String)category)) {
                case "WHITESPACE": 
                case "HEXDIGIT": 
                case "NONCHARACTERCODEPOINT": 
                case "JOINCONTROL": 
                case "ALPHABETIC": 
                case "LETTER": 
                case "IDEOGRAPHIC": 
                case "LOWERCASE": 
                case "UPPERCASE": 
                case "TITLECASE": 
                case "WHITE_SPACE": 
                case "CONTROL": 
                case "PUNCTUATION": 
                case "HEX_DIGIT": 
                case "ASSIGNED": 
                case "NONCHARACTER_CODE_POINT": 
                case "DIGIT": 
                case "ALNUM": 
                case "BLANK": 
                case "GRAPH": 
                case "PRINT": 
                case "WORD": 
                case "JOIN_CONTROL": {
                    return true;
                }
            }
            return JavaRegExpHost.isValidUnicodeScript(category);
        }
        return this.isValidProperty(category);
    }

    private boolean isValidProperty(@NotNull String category) {
        if (category == null) {
            JavaRegExpHost.$$$reportNull$$$0(12);
        }
        for (String[] name2 : this.myPropertyNames) {
            if (!name2[0].equals(category)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidUnicodeBlock(@NotNull String category) {
        if (category == null) {
            JavaRegExpHost.$$$reportNull$$$0(13);
        }
        try {
            return Character.UnicodeBlock.forName(category) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isValidUnicodeScript(@NotNull String category) {
        if (category == null) {
            JavaRegExpHost.$$$reportNull$$$0(14);
        }
        try {
            return Character.UnicodeScript.forName(category) != null;
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    public boolean isValidNamedCharacter(RegExpNamedCharacter namedCharacter) {
        return UnicodeCharacterNames.getCodePoint((String)namedCharacter.getName()) >= 0;
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        if (lookbehindGroup == null) {
            JavaRegExpHost.$$$reportNull$$$0(15);
        }
        return RegExpLanguageHost.Lookbehind.FINITE_REPETITION;
    }

    public Integer getQuantifierValue(@NotNull RegExpNumber number) {
        if (number == null) {
            JavaRegExpHost.$$$reportNull$$$0(16);
        }
        try {
            return Integer.valueOf(number.getUnescapedText());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return this.myPropertyNames;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name2) {
        if (StringUtil.isEmptyOrSpaces((String)name2)) {
            return null;
        }
        for (String[] stringArray : this.myPropertyNames) {
            if (!stringArray[0].equals(name2)) continue;
            return stringArray.length > 1 ? stringArray[1] : stringArray[0];
        }
        return null;
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return this.myPropertiesProvider.getKnownCharacterClasses();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/JavaRegExpHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/JavaRegExpHost";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidGroupName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isScriptProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBlockProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCategoryProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidUnicodeBlock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidUnicodeScript";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQuantifierValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

