/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.EmptySubstitutor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnmodifiableHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance(PsiSubstitutorImpl.class);
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        public int computeHashCode(PsiTypeParameter parameter2) {
            return Comparing.hashcode((Object)parameter2.getName());
        }

        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent((PsiElement)element1, (PsiElement)element2);
        }
    };
    private static final UnmodifiableHashMap<PsiTypeParameter, PsiType> EMPTY_MAP = UnmodifiableHashMap.empty(PSI_EQUIVALENCE);
    @NotNull
    private final UnmodifiableHashMap<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor;

    PsiSubstitutorImpl(@NotNull Map<? extends PsiTypeParameter, ? extends PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(0);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = UnmodifiableHashMap.fromMap(PSI_EQUIVALENCE, map2);
    }

    private PsiSubstitutorImpl(@NotNull UnmodifiableHashMap<PsiTypeParameter, PsiType> map2, @NotNull PsiTypeParameter additionalKey, @Nullable PsiType additionalValue) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(1);
        }
        if (additionalKey == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(2);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = map2.with((Object)additionalKey, (Object)additionalValue);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(3);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = EMPTY_MAP.with((Object)typeParameter, (Object)mapping);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(4);
        }
        this((Map<? extends PsiTypeParameter, ? extends PsiType>)PsiSubstitutorImpl.putAllInternal(EMPTY_MAP, parentClass, mappings));
    }

    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        PsiType type2;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(5);
        }
        return PsiType.VOID.equals((Object)(type2 = this.getFromMap(typeParameter))) ? JavaPsiFacade.getElementFactory((Project)typeParameter.getProject()).createType((PsiClass)typeParameter) : type2;
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(6);
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return (PsiType)this.mySubstitutionMap.getOrDefault((Object)typeParameter, (Object)PsiType.VOID);
    }

    public PsiType substitute(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        PsiUtil.ensureValidType((PsiType)type2);
        PsiType substituted = (PsiType)type2.accept((PsiTypeVisitor)this.mySimpleSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type2);
    }

    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        PsiType substituted;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(7);
        }
        if ((substituted = this.substitute(typeParameter)) instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiWildcardType wildcard;
            PsiWildcardType wildcardType = (PsiWildcardType)substituted;
            PsiType glb = PsiCapturedWildcardType.captureUpperBound((PsiTypeParameter)typeParameter, (PsiWildcardType)wildcardType, (PsiSubstitutor)this);
            if (glb instanceof PsiWildcardType) {
                return glb;
            }
            if (glb instanceof PsiCapturedWildcardType && !(wildcard = ((PsiCapturedWildcardType)glb).getWildcard()).isSuper()) {
                return wildcard;
            }
            if (glb != null) {
                return PsiWildcardType.createExtends((PsiManager)typeParameter.getManager(), (PsiType)glb);
            }
        }
        return substituted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof PsiSubstitutorImpl && this.mySubstitutionMap.equals(((PsiSubstitutorImpl)o).mySubstitutionMap);
    }

    public int hashCode() {
        return this.mySubstitutionMap.hashCode();
    }

    private PsiType rawTypeForTypeParameter(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(8);
        }
        if ((extendsTypes = typeParameter.getExtendsListTypes()).length > 0) {
            return (PsiType)RecursionManager.doPreventingRecursion((Object)extendsTypes[0], (boolean)true, () -> this.substitute((PsiType)extendsTypes[0]));
        }
        return PsiType.getJavaLangObject((PsiManager)typeParameter.getManager(), (GlobalSearchScope)typeParameter.getResolveScope());
    }

    @NotNull
    private static TypeAnnotationProvider getMergedProvider(@NotNull PsiType type1, @NotNull PsiType type2) {
        if (type1 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(10);
        }
        if (type1.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type1 instanceof PsiClassReferenceType)) {
            TypeAnnotationProvider typeAnnotationProvider = type2.getAnnotationProvider();
            if (typeAnnotationProvider == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(11);
            }
            return typeAnnotationProvider;
        }
        if (type2.getAnnotationProvider() == TypeAnnotationProvider.EMPTY && !(type2 instanceof PsiClassReferenceType)) {
            TypeAnnotationProvider typeAnnotationProvider = type1.getAnnotationProvider();
            if (typeAnnotationProvider == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(12);
            }
            return typeAnnotationProvider;
        }
        TypeAnnotationProvider typeAnnotationProvider = () -> (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])type1.getAnnotations(), (Object[])type2.getAnnotations());
        if (typeAnnotationProvider == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(13);
        }
        return typeAnnotationProvider;
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(14);
        }
        if (substituted != null) {
            return substituted;
        }
        return (PsiType)original.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new PsiArrayType((PsiType)arrayType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
                if (ellipsisType == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new PsiEllipsisType((PsiType)ellipsisType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((aClass = classType.resolve()) == null) {
                    return classType;
                }
                if (aClass instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass);
                }
                return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
            }

            public PsiType visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ellipsisType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEllipsisType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(15);
        }
        if (mapping != null && !mapping.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping + "; " + mapping.getClass());
        }
        return new PsiSubstitutorImpl(this.mySubstitutionMap, typeParameter, mapping);
    }

    @NotNull
    private static UnmodifiableHashMap<PsiTypeParameter, PsiType> putAllInternal(@NotNull UnmodifiableHashMap<PsiTypeParameter, PsiType> originalMap, @NotNull PsiClass parentClass, PsiType[] mappings) {
        PsiTypeParameter[] params;
        if (originalMap == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(16);
        }
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(17);
        }
        if ((params = parentClass.getTypeParameters()).length == 0) {
            UnmodifiableHashMap unmodifiableHashMap = originalMap;
            if (unmodifiableHashMap == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(18);
            }
            return unmodifiableHashMap;
        }
        UnmodifiableHashMap newMap = originalMap;
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping = mappings[i];
                newMap = newMap.with((Object)param, (Object)mapping);
                if (mapping == null || mapping.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping);
                continue;
            }
            newMap = newMap.with((Object)param, null);
        }
        UnmodifiableHashMap unmodifiableHashMap = newMap;
        if (unmodifiableHashMap == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(19);
        }
        return unmodifiableHashMap;
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(20);
        }
        return new PsiSubstitutorImpl((Map<? extends PsiTypeParameter, ? extends PsiType>)PsiSubstitutorImpl.putAllInternal(this.mySubstitutionMap, parentClass, mappings));
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(21);
        }
        if (another instanceof EmptySubstitutor) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(22);
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        PsiSubstitutor psiSubstitutor = this.putAll((Map<? extends PsiTypeParameter, ? extends PsiType>)anotherImpl.mySubstitutionMap);
        if (psiSubstitutor == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(23);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull Map<? extends PsiTypeParameter, ? extends PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(24);
        }
        if (map2.isEmpty()) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(25);
            }
            return psiSubstitutorImpl;
        }
        return new PsiSubstitutorImpl((Map<? extends PsiTypeParameter, ? extends PsiType>)this.mySubstitutionMap.withAll(map2));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set set = this.mySubstitutionMap.entrySet();
        for (Map.Entry entry : set) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner2 = typeParameter.getOwner();
            if (owner2 instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner2).getQualifiedName());
            } else if (owner2 instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner2).getName());
                buffer.append(" in ");
                PsiClass aClass = ((PsiMethod)owner2).getContainingClass();
                buffer.append(aClass != null ? aClass.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(((PsiType)entry.getValue()).getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public boolean isValid() {
        for (Map.Entry entry : this.mySubstitutionMap.entrySet()) {
            if (!((PsiTypeParameter)entry.getKey()).isValid()) {
                return false;
            }
            PsiType type2 = (PsiType)entry.getValue();
            if (type2 == null || type2.isValid()) continue;
            return false;
        }
        return true;
    }

    public void ensureValid() {
        this.mySubstitutionMap.values().forEach(type2 -> {
            if (type2 != null) {
                PsiUtil.ensureValidType((PsiType)type2);
            }
        });
    }

    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        UnmodifiableHashMap<PsiTypeParameter, PsiType> unmodifiableHashMap = this.mySubstitutionMap;
        if (unmodifiableHashMap == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(26);
        }
        return unmodifiableHashMap;
    }

    @Deprecated
    public static PsiSubstitutor createSubstitutor(@Nullable Map<? extends PsiTypeParameter, ? extends PsiType> map2) {
        return PsiSubstitutor.createSubstitutor(map2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalKey";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 4: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMap";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedProvider";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "putAllInternal";
                break;
            }
            case 22: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "putAll";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFromMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithBoundsPromotion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rawTypeForTypeParameter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMergedProvider";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "correctExternalSubstitution";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putAllInternal";
                break;
            }
            case 20: 
            case 21: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SubstitutionVisitor
    extends PsiTypeMapper {
        private SubstitutionVisitor() {
        }

        @Override
        public PsiType visitType(@NotNull PsiType type2) {
            if (type2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
            PsiType bound;
            if (wildcardType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(1);
            }
            if ((bound = wildcardType.getBound()) == null) {
                return wildcardType;
            }
            PsiType newBound = (PsiType)bound.accept((PsiTypeVisitor)this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                PsiType newBoundBound = ((PsiWildcardType)newBound).getBound();
                return !((PsiWildcardType)newBound).isBounded() ? PsiWildcardType.createUnbounded((PsiManager)wildcardType.getManager()) : this.rebound(wildcardType, newBoundBound);
            }
            return newBound == PsiType.NULL ? newBound : this.rebound(wildcardType, newBound);
        }

        @NotNull
        private PsiWildcardType rebound(@NotNull PsiWildcardType type2, @NotNull PsiType newBound) {
            if (type2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(2);
            }
            if (newBound == null) {
                SubstitutionVisitor.$$$reportNull$$$0(3);
            }
            LOG.assertTrue(type2.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type2.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded((PsiManager)type2.getManager());
                    if (psiWildcardType == null) {
                        SubstitutionVisitor.$$$reportNull$$$0(4);
                    }
                    return psiWildcardType;
                }
                PsiWildcardType psiWildcardType = PsiWildcardType.createExtends((PsiManager)type2.getManager(), (PsiType)newBound);
                if (psiWildcardType == null) {
                    SubstitutionVisitor.$$$reportNull$$$0(5);
                }
                return psiWildcardType;
            }
            PsiWildcardType psiWildcardType = PsiWildcardType.createSuper((PsiManager)type2.getManager(), (PsiType)newBound);
            if (psiWildcardType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(6);
            }
            return psiWildcardType;
        }

        @Override
        public PsiType visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (classType == null) {
                SubstitutionVisitor.$$$reportNull$$$0(7);
            }
            if ((aClass = (resolveResult = classType.resolveGenerics()).getElement()) == null) {
                return classType;
            }
            PsiUtilCore.ensureValid((PsiElement)aClass);
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                PsiType result = PsiSubstitutorImpl.this.getFromMap(typeParameter);
                if (PsiType.VOID.equals((Object)result)) {
                    return classType;
                }
                if (result != null) {
                    PsiUtil.ensureValidType((PsiType)result);
                    if (result instanceof PsiClassType || result instanceof PsiArrayType || result instanceof PsiWildcardType) {
                        return result.annotate(PsiSubstitutorImpl.getMergedProvider((PsiType)classType, result));
                    }
                }
                return result;
            }
            HashMap<PsiTypeParameter, PsiType> hashMap = new HashMap<PsiTypeParameter, PsiType>(2);
            if (!this.processClass(aClass, resolveResult.getSubstitutor(), hashMap)) {
                return null;
            }
            PsiClassType result = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, PsiSubstitutor.createSubstitutor(hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType((PsiType)result);
            return result.annotate(classType.getAnnotationProvider());
        }

        private PsiType substituteInternal(@NotNull PsiType type2) {
            if (type2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(8);
            }
            return (PsiType)type2.accept((PsiTypeVisitor)this);
        }

        private boolean processClass(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor originalSubstitutor, @NotNull Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params;
            if (resolve2 == null) {
                SubstitutionVisitor.$$$reportNull$$$0(9);
            }
            if (originalSubstitutor == null) {
                SubstitutionVisitor.$$$reportNull$$$0(10);
            }
            if (substMap == null) {
                SubstitutionVisitor.$$$reportNull$$$0(11);
            }
            for (PsiTypeParameter param : params = resolve2.getTypeParameters()) {
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                substMap.put(param, this.substituteInternal(original));
            }
            if (resolve2.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve2.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wildcardType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBound";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolve";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalSubstitutor";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rebound";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitType";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWildcardType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "rebound";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassType";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteInternal";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "processClass";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

