/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class HighlightingCaches {
    private final List<Map<?, ?>> allCaches;
    final ConcurrentMap<PsiClass, PsiClass[]> DIRECT_SUB_CLASSES;
    final ConcurrentMap<PsiClass, Iterable<PsiClass>> ALL_SUB_CLASSES;
    final ConcurrentMap<PsiClass, Iterable<PsiClass>> ALL_SUB_CLASSES_NO_ANONYMOUS;
    final Map<PsiMethod, Iterable<PsiMethod>> OVERRIDING_METHODS;

    public static HighlightingCaches getInstance(Project project) {
        return (HighlightingCaches)ServiceManager.getService((Project)project, HighlightingCaches.class);
    }

    HighlightingCaches(@NotNull Project project) {
        if (project == null) {
            HighlightingCaches.$$$reportNull$$$0(0);
        }
        this.allCaches = ContainerUtil.createConcurrentList();
        this.DIRECT_SUB_CLASSES = this.createWeakCache();
        this.ALL_SUB_CLASSES = this.createWeakCache();
        this.ALL_SUB_CLASSES_NO_ANONYMOUS = this.createWeakCache();
        this.OVERRIDING_METHODS = this.createWeakCache();
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    HighlightingCaches.this.allCaches.forEach(Map::clear);
                }
            }

            public void afterPsiChanged(boolean isPhysical) {
            }
        });
    }

    @NotNull
    private <T, V> ConcurrentMap<T, V> createWeakCache() {
        ConcurrentMap map2 = ContainerUtil.createConcurrentWeakKeySoftValueMap((int)10, (float)0.7f, (int)Runtime.getRuntime().availableProcessors(), (TObjectHashingStrategy)ContainerUtil.canonicalStrategy());
        this.allCaches.add(map2);
        ConcurrentMap concurrentMap = map2;
        if (concurrentMap == null) {
            HighlightingCaches.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/HighlightingCaches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/HighlightingCaches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

