/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.JavaIndexPatternBuilder;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JspIndexPatternBuilder
implements IndexPatternBuilder {
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            JspIndexPatternBuilder.$$$reportNull$$$0(0);
        }
        if (JspPsiUtil.isInJspFile((PsiElement)file)) {
            return EditorHighlighterCache.getLexerBasedOnLexerHighlighter((CharSequence)file.getText(), (VirtualFile)file.getVirtualFile(), (Project)file.getProject());
        }
        return null;
    }

    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            JspIndexPatternBuilder.$$$reportNull$$$0(1);
        }
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        TokenSet commentTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{JavaIndexPatternBuilder.XML_COMMENT_BIT_SET, StdTokenSets.COMMENT_BIT_SET});
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(jspFile.getViewProvider().getTemplateDataLanguage());
        if (parserDefinition != null) {
            commentTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{commentTokens, parserDefinition.getCommentTokens()});
        }
        return commentTokens;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        return tokenType == JspTokenType.JSP_COMMENT ? "<%--".length() : 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == JspTokenType.JSP_COMMENT ? "--%>".length() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/psi/impl/search/JspIndexPatternBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentTokenSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

