/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import com.intellij.util.CharTable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PsiDocCommentImpl
extends LazyParseablePsiElement
implements PsiDocComment,
JavaTokenType,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiDocCommentImpl.class);
    private static final TokenSet TAG_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{DOC_TAG});
    private static final ArrayFactory<PsiDocTag> ARRAY_FACTORY = count -> count == 0 ? PsiDocTag.EMPTY_ARRAY : new PsiDocTag[count];
    private static final Pattern WS_PATTERN = Pattern.compile("\\s*");

    public PsiDocCommentImpl(CharSequence text2) {
        super((IElementType)JavaDocElementType.DOC_COMMENT, text2);
    }

    public PsiJavaDocumentedElement getOwner() {
        return PsiImplUtil.findDocCommentOwner(this);
    }

    public PsiElement @NotNull [] getDescriptionElements() {
        IElementType i;
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (TreeElement child = this.getFirstChildNode(); child != null && (i = child.getElementType()) != DOC_TAG; child = child.getTreeNext()) {
            if (i == DOC_COMMENT_START || i == DOC_COMMENT_END || i == DOC_COMMENT_LEADING_ASTERISKS) continue;
            array.add(child.getPsi());
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    public PsiDocTag @NotNull [] getTags() {
        PsiDocTag[] psiDocTagArray = (PsiDocTag[])this.getChildrenAsPsiElements(TAG_BIT_SET, ARRAY_FACTORY);
        if (psiDocTagArray == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(1);
        }
        return psiDocTagArray;
    }

    public PsiDocTag findTagByName(String name2) {
        if (this.getFirstChildNode().getElementType() == JavaDocElementType.DOC_COMMENT && !this.getFirstChildNode().getText().contains(name2)) {
            return null;
        }
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiDocTag tag;
            CharSequence nameText;
            if (child.getElementType() != DOC_TAG || (nameText = ((LeafElement)(tag = (PsiDocTag)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)child)).getNameElement()).getChars()).length() <= 0 || nameText.charAt(0) != '@' || !CharArrayUtil.regionMatches((CharSequence)nameText, (int)1, (CharSequence)name2)) continue;
            return tag;
        }
        return null;
    }

    public PsiDocTag @NotNull [] findTagsByName(String name2) {
        ArrayList<PsiDocTag> array = new ArrayList<PsiDocTag>();
        name2 = "@" + name2;
        for (PsiDocTag tag : this.getTags()) {
            if (!tag.getNameElement().getText().equals(name2)) continue;
            array.add(tag);
        }
        PsiDocTag[] psiDocTagArray = array.toArray(PsiDocTag.EMPTY_ARRAY);
        if (psiDocTagArray == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(2);
        }
        return psiDocTagArray;
    }

    @NotNull
    public IElementType getTokenType() {
        IElementType iElementType = this.getElementType();
        if (iElementType == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 110: {
                return this.getFirstChildNode();
            }
            case 111: {
                TreeElement lastNode = this.getLastChildNode();
                return lastNode.getElementType() == DOC_COMMENT_END ? lastNode : null;
            }
        }
        return null;
    }

    private static boolean isWhitespaceCommentData(ASTNode docCommentData) {
        return WS_PATTERN.matcher(docCommentData.getText()).matches();
    }

    private static void addNewLineToTag(CompositeElement tag, Project project, PsiManager manager) {
        TreeElement current;
        LOG.assertTrue(tag != null && tag.getElementType() == DOC_TAG);
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA && PsiDocCommentImpl.isWhitespaceCommentData((ASTNode)current); current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            return;
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)tag);
        if (JavaCodeStyleSettingsFacade.getInstance((Project)project).isJavaDocLeadingAsterisksEnabled()) {
            tag.addChild((ASTNode)Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)"\n ", (CharTable)charTable, (PsiManager)manager));
            tag.addChild((ASTNode)Factory.createSingleLeafElement((IElementType)DOC_COMMENT_LEADING_ASTERISKS, (CharSequence)"*", (CharTable)charTable, (PsiManager)manager));
            tag.addChild((ASTNode)Factory.createSingleLeafElement((IElementType)DOC_COMMENT_DATA, (CharSequence)" ", (CharTable)charTable, (PsiManager)manager));
        } else {
            tag.addChild((ASTNode)Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)"\n ", (CharTable)charTable, (PsiManager)manager));
        }
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before2) {
        boolean needToAddNewline = false;
        if (first == last && first.getElementType() == DOC_TAG) {
            if (anchor == null) {
                anchor = this.getLastChildNode();
                ASTNode prevBeforeWS = TreeUtil.skipElementsBack((ASTNode)anchor.getTreePrev(), (TokenSet)TokenSet.WHITE_SPACE);
                if (prevBeforeWS != null) {
                    anchor = prevBeforeWS;
                    before2 = Boolean.FALSE;
                } else {
                    before2 = Boolean.TRUE;
                }
                needToAddNewline = true;
            }
            if (anchor.getElementType() != DOC_TAG) {
                if (PsiDocCommentImpl.nodeOnSameLineWithCommentStartBlock(anchor) || !PsiDocCommentImpl.nodeIsNextAfterAsterisks(anchor) || !PsiDocCommentImpl.docTagEndsWithLineFeedAndAsterisks((ASTNode)first)) {
                    CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)this);
                    PsiManagerEx psiManager = this.getManager();
                    if (JavaCodeStyleSettingsFacade.getInstance((Project)this.getProject()).isJavaDocLeadingAsterisksEnabled()) {
                        LeafElement newLine = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)"\n ", (CharTable)charTable, (PsiManager)psiManager);
                        LeafElement leadingAsterisk = Factory.createSingleLeafElement((IElementType)DOC_COMMENT_LEADING_ASTERISKS, (CharSequence)"*", (CharTable)charTable, (PsiManager)psiManager);
                        LeafElement commentData = Factory.createSingleLeafElement((IElementType)DOC_COMMENT_DATA, (CharSequence)" ", (CharTable)charTable, (PsiManager)psiManager);
                        newLine.getTreeParent().addChild((ASTNode)leadingAsterisk);
                        newLine.getTreeParent().addChild((ASTNode)commentData);
                        super.addInternal((TreeElement)newLine, (ASTNode)commentData, anchor, Boolean.FALSE);
                        anchor = commentData;
                    } else {
                        LeafElement newLine = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)"\n ", (CharTable)charTable, (PsiManager)psiManager);
                        anchor = super.addInternal((TreeElement)newLine, (ASTNode)newLine, anchor, Boolean.FALSE);
                    }
                    before2 = Boolean.FALSE;
                }
            } else {
                needToAddNewline = true;
            }
        }
        if (before2.booleanValue()) {
            anchor.getTreeParent().addChildren((ASTNode)first, last.getTreeNext(), anchor);
        } else {
            anchor.getTreeParent().addChildren((ASTNode)first, last.getTreeNext(), anchor.getTreeNext());
        }
        if (needToAddNewline) {
            if (first.getTreePrev() != null && first.getTreePrev().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first.getTreePrev(), this.getProject(), (PsiManager)this.getManager());
            }
            if (first.getTreeNext() != null && first.getTreeNext().getElementType() == DOC_TAG) {
                PsiDocCommentImpl.addNewLineToTag((CompositeElement)first, this.getProject(), (PsiManager)this.getManager());
            } else {
                PsiDocCommentImpl.removeEndingAsterisksFromTag((CompositeElement)first);
            }
        }
        return first;
    }

    private static void removeEndingAsterisksFromTag(CompositeElement tag) {
        TreeElement current;
        for (current = tag.getLastChildNode(); current != null && current.getElementType() == DOC_COMMENT_DATA; current = current.getTreePrev()) {
        }
        if (current != null && current.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
            ASTNode prevWhiteSpace = TreeUtil.skipElementsBack((ASTNode)current.getTreePrev(), (TokenSet)TokenSet.WHITE_SPACE);
            assert (prevWhiteSpace != null);
            ASTNode toBeDeleted = prevWhiteSpace.getTreeNext();
            while (toBeDeleted != null) {
                ASTNode next = toBeDeleted.getTreeNext();
                tag.deleteChildInternal(toBeDeleted);
                toBeDeleted = next;
            }
        }
    }

    private static boolean nodeIsNextAfterAsterisks(@NotNull ASTNode node) {
        ASTNode current;
        if (node == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(4);
        }
        if ((current = TreeUtil.findSiblingBackward((ASTNode)node, (IElementType)DOC_COMMENT_LEADING_ASTERISKS)) == null || current == node) {
            return false;
        }
        while (current.getTreeNext() != node) {
            CharSequence currentText = (current = current.getTreeNext()).getChars();
            if (CharArrayUtil.shiftForward((CharSequence)currentText, (int)0, (String)" \t") == currentText.length()) continue;
            return false;
        }
        return true;
    }

    private static boolean docTagEndsWithLineFeedAndAsterisks(@NotNull ASTNode node) {
        if (node == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(5);
        }
        assert (node.getElementType() == DOC_TAG);
        ASTNode lastAsterisks = TreeUtil.findChildBackward((ASTNode)node, (IElementType)DOC_COMMENT_LEADING_ASTERISKS);
        if (lastAsterisks == null || !lastAsterisks.getTreePrev().textContains('\n')) {
            return false;
        }
        ASTNode last = node.getLastChildNode();
        ASTNode current = lastAsterisks;
        while (current != last) {
            CharSequence currentText = (current = current.getTreeNext()).getChars();
            if (CharArrayUtil.shiftForward((CharSequence)currentText, (int)0, (String)" \t") == currentText.length()) continue;
            return false;
        }
        return true;
    }

    private static boolean nodeOnSameLineWithCommentStartBlock(@NotNull ASTNode node) {
        ASTNode current;
        if (node == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(6);
        }
        if ((current = TreeUtil.findSiblingBackward((ASTNode)node, (IElementType)DOC_COMMENT_START)) == null) {
            return false;
        }
        if (current == node) {
            return true;
        }
        while (current.getTreeNext() != node) {
            if (!(current = current.getTreeNext()).textContains('\n')) continue;
            return false;
        }
        return true;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(7);
        }
        if (child.getElementType() == DOC_TAG && (child.getTreeNext() == null || child.getTreeNext().getElementType() != DOC_TAG)) {
            ASTNode next;
            ASTNode prev;
            for (prev = child.getTreePrev(); prev != null && prev.getElementType() == DOC_COMMENT_DATA; prev = prev.getTreePrev()) {
            }
            for (next = child.getTreeNext(); next != null && (next.getElementType() == DOC_COMMENT_DATA || next.getElementType() == WHITE_SPACE); next = next.getTreeNext()) {
            }
            if (prev != null && prev.getElementType() == DOC_COMMENT_LEADING_ASTERISKS && !(next instanceof PsiDocTag)) {
                if (prev.getTreePrev() != null) {
                    super.deleteChildInternal(prev.getTreePrev());
                    super.deleteChildInternal(prev);
                }
            } else if (prev != null && prev.getElementType() == DOC_TAG) {
                TreeElement prevChild;
                CompositeElement compositePrev = (CompositeElement)prev;
                for (prevChild = compositePrev.getLastChildNode(); prevChild != null && prevChild.getElementType() == DOC_COMMENT_DATA; prevChild = prevChild.getTreePrev()) {
                }
                if (prevChild != null && prevChild.getElementType() == DOC_COMMENT_LEADING_ASTERISKS) {
                    TreeElement current = prevChild;
                    while (current != null) {
                        ASTNode nextChild = current.getTreeNext();
                        compositePrev.deleteChildInternal((ASTNode)current);
                        current = nextChild;
                    }
                }
            } else {
                next = child.getTreeNext();
                if (next != null && next.getElementType() == WHITE_SPACE) {
                    next.getTreeParent().removeChild(next);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == DOC_TAG) {
            return 104;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_COMMENT_LEADING_ASTERISKS) {
            return 107;
        }
        if (i == DOC_COMMENT_START) {
            return 110;
        }
        if (i == DOC_COMMENT_END) {
            return 111;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiDocCommentImpl.$$$reportNull$$$0(9);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitDocComment((PsiDocComment)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiDocComment";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findTagsByName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiDocCommentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "nodeIsNextAfterAsterisks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "docTagEndsWithLineFeedAndAsterisks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nodeOnSameLineWithCommentStartBlock";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

