/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeCompatibilityConstraint
implements ConstraintFormula {
    private PsiType myT;
    private PsiType myS;

    public TypeCompatibilityConstraint(@NotNull PsiType t, @NotNull PsiType s) {
        if (t == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(0);
        }
        if (s == null) {
            TypeCompatibilityConstraint.$$$reportNull$$$0(1);
        }
        this.myT = t.annotate(TypeAnnotationProvider.EMPTY);
        this.myS = s.annotate(TypeAnnotationProvider.EMPTY);
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiClassType boxedType;
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            boolean assignable = TypeConversionUtil.isAssignable((PsiType)this.myT, (PsiType)this.myS);
            if (!assignable) {
                session.registerIncompatibleErrorMessage("Incompatible types: " + session.getPresentableText(this.myS) + " is not convertible to " + session.getPresentableText(this.myT));
            }
            return assignable;
        }
        if (this.myS instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)this.myS) && (boxedType = ((PsiPrimitiveType)this.myS).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeCompatibilityConstraint(this.myT, (PsiType)boxedType));
            return true;
        }
        if (this.myT instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)this.myT) && (boxedType = ((PsiPrimitiveType)this.myT).getBoxedType(session.getManager(), session.getScope())) != null) {
            constraints.add(new TypeEqualityConstraint((PsiType)boxedType, this.myS));
            return true;
        }
        if (TypeCompatibilityConstraint.isUncheckedConversion(this.myT, this.myS, session)) {
            session.setErased();
            return true;
        }
        constraints.add(new StrictSubtypingConstraint(this.myT, this.myS));
        return true;
    }

    public static boolean isUncheckedConversion(PsiType t, PsiType s, InferenceSession session) {
        if (t instanceof PsiClassType && !((PsiClassType)t).isRaw()) {
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)t).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            if (s instanceof PsiClassType && TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)s, session)) {
                return true;
            }
            if (s instanceof PsiIntersectionType) {
                for (PsiType conjunct : ((PsiIntersectionType)s).getConjuncts()) {
                    if (!(conjunct instanceof PsiClassType) || !TypeCompatibilityConstraint.isUncheckedConversion(tClass, (PsiClassType)conjunct, session)) continue;
                    return true;
                }
            }
        } else if (t instanceof PsiArrayType && s != null && t.getArrayDimensions() == s.getArrayDimensions()) {
            return TypeCompatibilityConstraint.isUncheckedConversion(t.getDeepComponentType(), s.getDeepComponentType(), session);
        }
        return false;
    }

    private static boolean isUncheckedConversion(PsiClass tClass, PsiClassType s, InferenceSession session) {
        PsiClassType.ClassResolveResult sResult = s.resolveGenerics();
        PsiClass sClass = sResult.getElement();
        if (tClass != null && sClass != null && !(sClass instanceof InferenceVariable)) {
            PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)tClass, (PsiClass)sClass, (PsiSubstitutor)sResult.getSubstitutor());
            if (sSubstitutor != null) {
                if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)tClass, (PsiSubstitutor)sSubstitutor)) {
                    return true;
                }
            } else if (tClass instanceof InferenceVariable && s.isRaw()) {
                for (PsiType bound : ((InferenceVariable)tClass).getBounds(InferenceBound.UPPER)) {
                    PsiClass boundClass;
                    if (session.isProperType(bound) || (boundClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)bound)) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)boundClass, (PsiClass)sClass, (boolean)true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibilityConstraint that = (TypeCompatibilityConstraint)o;
        if (!this.myS.equals(that.myS)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result = this.myT.hashCode();
        result = 31 * result + this.myS.hashCode();
        return result;
    }

    public String toString() {
        return this.myS.getPresentableText() + " -> " + this.myT.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "t";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "s";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/resolve/graphInference/constraints/TypeCompatibilityConstraint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

