/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.impl.source.tree.java.FieldElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiArrayInitializerExpressionImpl
extends ExpressionPsiElement
implements PsiArrayInitializerExpression {
    private static final Logger LOG = Logger.getInstance(PsiArrayInitializerExpressionImpl.class);

    public PsiArrayInitializerExpressionImpl() {
        super(JavaElementType.ARRAY_INITIALIZER_EXPRESSION);
    }

    public PsiExpression @NotNull [] getInitializers() {
        PsiExpression[] psiExpressionArray = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        if (psiExpressionArray == null) {
            PsiArrayInitializerExpressionImpl.$$$reportNull$$$0(0);
        }
        return psiExpressionArray;
    }

    public PsiType getType() {
        if (this.getTreeParent() instanceof PsiNewExpression) {
            if (this.getTreeParent().getChildRole((ASTNode)this) == 77) {
                return ((PsiNewExpression)this.getTreeParent()).getType();
            }
        } else {
            if (this.getTreeParent() instanceof PsiVariable) {
                return ((PsiVariable)this.getTreeParent()).getType();
            }
            if (this.getTreeParent() instanceof PsiArrayInitializerExpression) {
                PsiType parentType = ((PsiArrayInitializerExpression)this.getTreeParent()).getType();
                if (!(parentType instanceof PsiArrayType)) {
                    return null;
                }
                PsiType componentType = ((PsiArrayType)parentType).getComponentType();
                return componentType instanceof PsiArrayType ? componentType : null;
            }
            if (this.getTreeParent() instanceof FieldElement) {
                return ((PsiField)this.getParent()).getType();
            }
        }
        return null;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return this.findChildByType(JavaTokenType.RBRACE);
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiArrayInitializerExpressionImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LBRACE) {
            return 18;
        }
        if (i == JavaTokenType.RBRACE) {
            return 19;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiArrayInitializerExpressionImpl.$$$reportNull$$$0(2);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitArrayInitializerExpression((PsiArrayInitializerExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiArrayInitializerExpression:" + this.getText();
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before2) {
        if (anchor == null) {
            if (before2 == null || before2.booleanValue()) {
                anchor = this.findChildByRole(19);
                before2 = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(18);
                before2 = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before2);
        if (ElementType.EXPRESSION_BIT_SET.contains(first.getElementType())) {
            LeafElement comma;
            TreeElement child;
            CharTable charTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
            for (child = first.getTreeNext(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreeNext()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement((IElementType)JavaTokenType.COMMA, (CharSequence)",", (int)0, (int)1, (CharTable)charTab, (PsiManager)this.getManager());
                super.addInternal((TreeElement)comma, (ASTNode)comma, (ASTNode)first, Boolean.FALSE);
                break;
            }
            for (child = first.getTreePrev(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreePrev()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                comma = Factory.createSingleLeafElement((IElementType)JavaTokenType.COMMA, (CharSequence)",", (int)0, (int)1, (CharTable)charTab, (PsiManager)this.getManager());
                super.addInternal((TreeElement)comma, (ASTNode)comma, (ASTNode)child, Boolean.FALSE);
                break;
            }
        }
        return firstAdded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializers";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

