/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiPatternUtil {
    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariables(@NotNull PsiExpression expression2) {
        PsiElement parent;
        boolean parentMayAccept;
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(0);
        }
        boolean bl = parentMayAccept = (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent).getOperationTokenType().equals(JavaTokenType.EXCL) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.ANDAND) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.OROR) || parent instanceof PsiConditionalExpression || parent instanceof PsiIfStatement || parent instanceof PsiConditionalLoopStatement;
        if (!parentMayAccept) {
            List<PsiPatternVariable> list = Collections.emptyList();
            if (list == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<PsiPatternVariable> list = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, false);
        ArrayList<PsiPatternVariable> arrayList = list;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariablesIgnoreParent(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(3);
        }
        ArrayList<PsiPatternVariable> list = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, true);
        ArrayList<PsiPatternVariable> arrayList = list;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static String getEffectiveInitializerText(@NotNull PsiPatternVariable variable) {
        PsiPattern pattern;
        PsiInstanceOfExpression instanceOf;
        if (variable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(5);
        }
        if ((instanceOf = (PsiInstanceOfExpression)ObjectUtils.tryCast((Object)(pattern = variable.getPattern()).getParent(), PsiInstanceOfExpression.class)) == null) {
            return null;
        }
        if (pattern instanceof PsiTypeTestPattern) {
            PsiExpression operand2 = instanceOf.getOperand();
            PsiTypeElement checkType = ((PsiTypeTestPattern)pattern).getCheckType();
            if (checkType.getType().equals(operand2.getType())) {
                return operand2.getText();
            }
            return "(" + checkType.getText() + ")" + operand2.getText();
        }
        return null;
    }

    private static void collectPatternVariableCandidates(@NotNull PsiExpression scope, @NotNull PsiExpression expression2, Collection<PsiPatternVariable> candidates, boolean strict) {
        PsiPolyadicExpression polyadicExpression;
        IElementType tokenType;
        PsiPatternVariable variable;
        PsiPattern pattern;
        if (scope == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(6);
        }
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(7);
        }
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiPrefixExpression) || !((PsiPrefixExpression)expression2).getOperationTokenType().equals(JavaTokenType.EXCL)) break;
            expression2 = ((PsiPrefixExpression)expression2).getOperand();
        }
        if (expression2 instanceof PsiInstanceOfExpression && (pattern = ((PsiInstanceOfExpression)expression2).getPattern()) instanceof PsiTypeTestPattern && (variable = ((PsiTypeTestPattern)pattern).getPatternVariable()) != null && !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)variable.getDeclarationScope(), (boolean)strict)) {
            candidates.add(variable);
        }
        if (expression2 instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)expression2).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                JavaPsiPatternUtil.collectPatternVariableCandidates(scope, operand2, candidates, strict);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariables";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveInitializerText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableCandidates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

