/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class PsiMatchers {
    private PsiMatchers() {
    }

    @NotNull
    public static PsiMatcherExpression hasName(final @NotNull String name2) {
        if (name2 == null) {
            PsiMatchers.$$$reportNull$$$0(0);
        }
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name2.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasText(final @NotNull String text2) {
        if (text2 == null) {
            PsiMatchers.$$$reportNull$$$0(1);
        }
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text2.length()) {
                    return Boolean.FALSE;
                }
                return text2.equals(element.getText());
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasText(final String ... texts) {
        if (texts == null) {
            PsiMatchers.$$$reportNull$$$0(2);
        }
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                String text2 = element.getText();
                return ArrayUtil.find((Object[])texts, (Object)text2) != -1;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final @NotNull Class<?> aClass) {
        if (aClass == null) {
            PsiMatchers.$$$reportNull$$$0(3);
        }
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (aClass.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final Class ... classes2) {
        if (classes2 == null) {
            PsiMatchers.$$$reportNull$$$0(4);
        }
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                for (Class aClass : classes2) {
                    if (!aClass.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiMatchers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

