/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplicitlyImportedWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<PsiPackage, ProximityLocation> PLACE_PACKAGE = NullableLazyKey.create((String)"placePackage", location -> {
        PsiElement position = location.getPosition();
        return position == null ? null : ExplicitlyImportedWeigher.getContextPackage(position);
    });
    private static final NotNullLazyKey<List<String>, ProximityLocation> PLACE_IMPORTED_NAMES = NotNullLazyKey.create((String)"importedNames", location -> {
        PsiImportList importList;
        PsiJavaFile psiJavaFile = (PsiJavaFile)PsiTreeUtil.getContextOfType((PsiElement)location.getPosition(), PsiJavaFile.class, (boolean)false);
        PsiImportList psiImportList = importList = psiJavaFile == null ? null : psiJavaFile.getImportList();
        if (importList == null) {
            return Collections.emptyList();
        }
        ArrayList importedNames = new ArrayList();
        for (PsiImportStatementBase statement : importList.getAllImportStatements()) {
            PsiJavaCodeReferenceElement reference = statement.getImportReference();
            ContainerUtil.addIfNotNull(importedNames, (Object)(reference == null ? null : reference.getQualifiedName()));
        }
        return importedNames;
    });

    @Nullable
    private static PsiPackage getContextPackage(PsiElement position) {
        PsiFile file = position.getContainingFile();
        if (file == null) {
            return null;
        }
        PsiFile originalFile = file.getOriginalFile();
        while (true) {
            PsiElement context;
            if ((context = originalFile.getContext()) == null) {
                PsiDirectory parent = originalFile.getParent();
                if (parent != null) {
                    return JavaDirectoryService.getInstance().getPackage(parent);
                }
                return null;
            }
            PsiFile containingFile = context.getContainingFile();
            if (containingFile == null) {
                return null;
            }
            originalFile = containingFile.getOriginalFile();
        }
    }

    public Integer weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        String qname;
        PsiElement position;
        if (element == null) {
            ExplicitlyImportedWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            ExplicitlyImportedWeigher.$$$reportNull$$$0(1);
        }
        if ((position = location.getPosition()) == null) {
            return 0;
        }
        PsiUtilCore.ensureValid((PsiElement)position);
        PsiFile elementFile = element.getContainingFile();
        PsiFile positionFile = position.getContainingFile();
        if (positionFile != null && elementFile != null && positionFile.getOriginalFile().equals(elementFile.getOriginalFile())) {
            return 300;
        }
        if (element instanceof PsiClass && (qname = ((PsiClass)element).getQualifiedName()) != null) {
            List importedNames = (List)PLACE_IMPORTED_NAMES.getValue((UserDataHolder)location);
            if (importedNames.contains(qname) || "java.lang".equals(StringUtil.getPackageName((String)qname))) {
                return 100;
            }
            if (ExplicitlyImportedWeigher.containsImport(importedNames, StringUtil.getPackageName((String)qname))) {
                return 50;
            }
        }
        if (element instanceof PsiMember) {
            qname = PsiUtil.getMemberQualifiedName((PsiMember)((PsiMember)element));
            if (qname != null && ((List)PLACE_IMPORTED_NAMES.getValue((UserDataHolder)location)).contains(qname)) {
                return 400;
            }
            PsiPackage placePackage = (PsiPackage)PLACE_PACKAGE.getValue((UserDataHolder)location);
            if (placePackage != null) {
                Module elementModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (location.getPositionModule() == elementModule && placePackage.equals(ExplicitlyImportedWeigher.getContextPackage(element))) {
                    return 200;
                }
            }
        }
        return 0;
    }

    private static boolean containsImport(List<String> importedNames, String pkg) {
        return ContainerUtil.or(importedNames, s -> s.startsWith(pkg + '.') || s.equals(pkg));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/ExplicitlyImportedWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

