/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class CopyClassDialog
extends RefactoringDialog
implements DumbAware {
    private static final String COPY_CLASS = "CopyClass";
    private static final String RECENTS_KEY = "CopyClassDialog.RECENTS_KEY";
    private final JLabel myInformationLabel = new JLabel();
    private EditorTextField myNameField;
    private final JLabel myPackageLabel = new JLabel();
    private ReferenceEditorComboWithBrowseButton myTfPackage;
    private final boolean myDoClone;
    private final PsiDirectory myDefaultTargetDirectory;
    private final DestinationFolderComboBox myDestinationCB = new DestinationFolderComboBox(){

        @Override
        public String getTargetPackage() {
            return CopyClassDialog.this.myTfPackage.getText().trim();
        }

        @Override
        protected boolean reportBaseInTestSelectionInSource() {
            return true;
        }
    };
    protected MoveDestination myDestination;

    CopyClassDialog(PsiClass aClass, PsiDirectory defaultTargetDirectory, Project project, boolean doClone) {
        super(project, true, true);
        this.myDefaultTargetDirectory = defaultTargetDirectory;
        this.myDoClone = doClone;
        String text2 = this.myDoClone ? JavaRefactoringBundle.message((String)"copy.class.clone.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)aClass), UsageViewUtil.getLongName((PsiElement)aClass)}) : JavaRefactoringBundle.message((String)"copy.class.copy.0.1", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)aClass), UsageViewUtil.getLongName((PsiElement)aClass)});
        this.myInformationLabel.setText(text2);
        this.myInformationLabel.setFont(this.myInformationLabel.getFont().deriveFont(1));
        this.init();
        this.myDestinationCB.setData(this.myProject, defaultTargetDirectory, new Pass<String>(){

            public void pass(String s) {
                CopyClassDialog.this.setErrorText(s, (JComponent)((Object)CopyClassDialog.this.myDestinationCB));
            }
        }, (EditorComboBox)this.myTfPackage.getChildComponent());
        this.myNameField.setText(UsageViewUtil.getShortName((PsiElement)aClass));
        this.myNameField.selectAll();
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    @NotNull
    protected String getRefactoringId() {
        return COPY_CLASS;
    }

    protected String getHelpId() {
        return "refactoring.copyClass";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        this.myNameField = new EditorTextField("");
        String qualifiedName = this.getQualifiedName();
        this.myTfPackage = new PackageNameReferenceEditorCombo(qualifiedName, this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        this.myTfPackage.setTextFieldPreferredWidth(Math.max(qualifiedName.length() + 5, 40));
        this.myPackageLabel.setText(JavaRefactoringBundle.message((String)"destination.package", (Object[])new Object[0]));
        this.myPackageLabel.setLabelFor((Component)((Object)this.myTfPackage));
        if (this.myDoClone) {
            this.myTfPackage.setVisible(false);
            this.myPackageLabel.setVisible(false);
        }
        JLabel label = new JLabel(RefactoringBundle.message((String)"target.destination.folder"));
        boolean isMultipleSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(this.myProject).size() > 1;
        this.myDestinationCB.setVisible(!this.myDoClone && isMultipleSourceRoots);
        label.setVisible(!this.myDoClone && isMultipleSourceRoots);
        label.setLabelFor((Component)((Object)this.myDestinationCB));
        JPanel panel2 = new JPanel(new BorderLayout());
        return FormBuilder.createFormBuilder().addComponent((JComponent)this.myInformationLabel).addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)this.myNameField, 12).addLabeledComponent((JComponent)this.myPackageLabel, (JComponent)((Object)this.myTfPackage)).addLabeledComponent((JComponent)label, (JComponent)((Object)this.myDestinationCB)).addComponent((JComponent)panel2).getPanel();
    }

    protected String getQualifiedName() {
        PsiPackage aPackage;
        String qualifiedName = "";
        if (this.myDefaultTargetDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(this.myDefaultTargetDirectory)) != null) {
            qualifiedName = aPackage.getQualifiedName();
        }
        return qualifiedName;
    }

    public MoveDestination getTargetDirectory() {
        return this.myDestination;
    }

    public String getClassName() {
        return this.myNameField.getText();
    }

    protected void doAction() {
        String packageName = this.myTfPackage.getText();
        String className2 = this.getClassName();
        String[] errorString = new String[1];
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)manager.getProject());
        if (packageName.length() > 0 && !nameHelper.isQualifiedName(packageName)) {
            errorString[0] = JavaRefactoringBundle.message((String)"invalid.target.package.name.specified", (Object[])new Object[0]);
        } else if (className2 != null && className2.isEmpty()) {
            errorString[0] = JavaRefactoringBundle.message((String)"no.class.name.specified", (Object[])new Object[0]);
        } else {
            if (!nameHelper.isIdentifier(className2)) {
                errorString[0] = RefactoringMessageUtil.getIncorrectIdentifierMessage(className2);
            } else if (!this.myDoClone) {
                try {
                    PackageWrapper targetPackage = new PackageWrapper(manager, packageName);
                    this.myDestination = this.myDestinationCB.selectDirectory(targetPackage, false);
                    if (this.myDestination == null) {
                        return;
                    }
                }
                catch (IncorrectOperationException e) {
                    errorString[0] = e.getMessage();
                }
            }
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        }
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)errorString[0], (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
            this.myNameField.requestFocusInWindow();
            return;
        }
        this.closeOKAction();
    }
}

