/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.newImpl.BodyBuilder;
import com.intellij.refactoring.extractMethod.newImpl.CallBuilder;
import com.intellij.refactoring.extractMethod.newImpl.SignatureBuilder;
import com.intellij.refactoring.extractMethod.newImpl.structures.CodeFragment;
import com.intellij.refactoring.extractMethod.newImpl.structures.FlowDependency;
import com.intellij.refactoring.extractMethod.newImpl.structures.StatementGroup;
import com.intellij.refactoring.util.VariableData;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class MethodExtractor {
    private final CodeFragment fragment;
    private final SignatureBuilder signatureBuilder;
    private final BodyBuilder bodyBuilder;
    private final CallBuilder callBuilder;

    private MethodExtractor(CodeFragment fragment, SignatureBuilder signatureBuilder, BodyBuilder bodyBuilder, CallBuilder callBuilder) {
        this.fragment = fragment;
        this.signatureBuilder = signatureBuilder;
        this.bodyBuilder = bodyBuilder;
        this.callBuilder = callBuilder;
    }

    public MethodExtractor methodName(String name2) {
        this.callBuilder.methodName(name2);
        this.signatureBuilder.methodName(name2);
        return this;
    }

    public MethodExtractor parameterNames(List<String> names2) {
        this.bodyBuilder.inputSubstitutions(names2);
        this.signatureBuilder.parameterNames(names2);
        return this;
    }

    public MethodExtractor parameterTypes(List<PsiType> types) {
        this.signatureBuilder.parameterTypes(types);
        return this;
    }

    public MethodExtractor tryToRemapParameters(VariableData[] variables) {
        List<String> oldCallParameters;
        List<VariableData> variablesData = Arrays.asList(variables);
        List newCallParameters = ContainerUtil.map(variablesData, variable -> variable.variable.getName());
        if (!new HashSet(newCallParameters).equals(new HashSet<String>(oldCallParameters = this.callBuilder.parameters()))) {
            return this;
        }
        List indexes = ContainerUtil.map((Collection)newCallParameters, name2 -> oldCallParameters.indexOf(name2));
        List newParameters = ContainerUtil.map(variablesData, variable -> variable.getName());
        List<PsiType> newTypes = MethodExtractor.reorder(this.signatureBuilder.parameterTypes(), indexes);
        List<List<PsiExpression>> newInputGroups = MethodExtractor.reorder(this.bodyBuilder.inputGroups(), indexes);
        this.bodyBuilder.inputSubstitutions(newParameters).inputGroups(newInputGroups);
        this.signatureBuilder.parameterNames(newParameters).parameterTypes(newTypes);
        this.callBuilder.parameters(newCallParameters);
        return this;
    }

    private static <T> List<T> reorder(List<T> list, List<Integer> indexes) {
        return ContainerUtil.map(indexes, index -> list.get((int)index));
    }

    public static MethodExtractor getInstance(List<PsiElement> elements) {
        CodeFragment fragment = CodeFragment.of(elements);
        FlowDependency dependencies = FlowDependency.computeDependency(fragment);
        ReturnMode returnMode = MethodExtractor.findReturnMode(dependencies);
        assert (returnMode != ReturnMode.MultipleVariables);
        BodyBuilder bodyBuilder = MethodExtractor.createBodyBuilder(returnMode, dependencies);
        CallBuilder callBuilder = MethodExtractor.createCallBuilder(returnMode, dependencies);
        SignatureBuilder signatureBuilder = MethodExtractor.createSignatureBuilder(returnMode, dependencies);
        List<String> defaultParameterNames = MethodExtractor.createDefaultParameterNames(dependencies);
        bodyBuilder.inputSubstitutions(defaultParameterNames);
        callBuilder.parameters(defaultParameterNames);
        signatureBuilder.parameterNames(defaultParameterNames);
        String defaultMethodName = "extracted";
        callBuilder.methodName(defaultMethodName);
        signatureBuilder.methodName(defaultMethodName);
        return new MethodExtractor(fragment, signatureBuilder, bodyBuilder, callBuilder);
    }

    public void extract() {
        List<PsiStatement> callStatements = this.callBuilder.build();
        PsiMethod extractedMethod = this.signatureBuilder.build();
        Objects.requireNonNull(extractedMethod.getBody()).replace((PsiElement)this.bodyBuilder.build());
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiElement parentMethod = PsiTreeUtil.findFirstParent((PsiElement)this.fragment.getCommonParent(), element -> element instanceof PsiMethod);
            Objects.requireNonNull(parentMethod).getParent().addAfter((PsiElement)extractedMethod, parentMethod);
            this.fragment.getCommonParent().addRangeBefore((PsiElement)callStatements.get(0), (PsiElement)callStatements.get(callStatements.size() - 1), this.fragment.getFirstElement());
            this.fragment.getCommonParent().deleteChildRange(this.fragment.getFirstElement(), this.fragment.getLastElement());
        });
    }

    private static CallBuilder createCallBuilder(ReturnMode returnMode, FlowDependency dependencies) {
        CallBuilder builder = new CallBuilder(dependencies.fragment.getProject());
        switch (returnMode) {
            case MethodCall: {
                return builder.methodCall();
            }
            case ConditionalExit: {
                return builder.guardMethodCall(dependencies.exitGroups.get((int)0).statements.get(0).getText());
            }
            case NullableExitVariable: {
                return builder.declareVariable(MethodExtractor.findReturnType(returnMode, dependencies), "out").returnNotNullVariable();
            }
            case ReturnMethodCall: {
                return builder.returnMethodCall();
            }
            case NullableVariable: {
                builder.guardNullVariable(dependencies.exitGroups.get((int)0).statements.get(0).getText());
            }
            case Variable: {
                PsiVariable outVariable = MethodExtractor.guessOutputVariable(dependencies);
                if (MethodExtractor.isDeclaredInside(dependencies.fragment, outVariable)) {
                    return builder.declareVariable(MethodExtractor.findReturnType(returnMode, dependencies), outVariable.getName());
                }
                return builder.assignToVariable(outVariable.getName());
            }
        }
        throw new UnsupportedOperationException("Unsupported return mode: " + (Object)((Object)returnMode));
    }

    private static boolean isDeclaredInside(CodeFragment fragment, PsiVariable variable) {
        return fragment.getTextRange().contains(variable.getTextRange());
    }

    private static PsiVariable guessOutputVariable(FlowDependency dependencies) {
        return dependencies.outputVariables.get(0);
    }

    private static SignatureBuilder createSignatureBuilder(ReturnMode returnMode, FlowDependency dependencies) {
        return new SignatureBuilder(dependencies.fragment.getProject()).makeStatic(MethodExtractor.isInsideStaticMethod(dependencies.fragment.getCommonParent())).throwExceptions(dependencies.thrownExceptions).parameterTypes(MethodExtractor.getDefaultParameterTypes(dependencies)).returnType(MethodExtractor.findReturnType(returnMode, dependencies));
    }

    private static List<PsiType> getDefaultParameterTypes(FlowDependency dependencies) {
        return dependencies.parameterTypes;
    }

    private static boolean isInsideStaticMethod(PsiElement element) {
        PsiMethod parentMethod = (PsiMethod)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiMethod.class);
        return parentMethod.getModifierList().hasModifierProperty("static");
    }

    private static BodyBuilder createBodyBuilder(ReturnMode returnMode, FlowDependency dependencies) {
        BodyBuilder builder = new BodyBuilder(dependencies.fragment).inputGroups(ContainerUtil.map(dependencies.parameterGroups, it -> it.references)).missedDeclarations(dependencies.missedDeclarations);
        switch (returnMode) {
            case Variable: {
                return builder.defaultReturn(dependencies.outputVariables.get(0).getName());
            }
            case ConditionalExit: {
                return builder.specialExits(dependencies.exitGroups.get((int)0).statements, "return true;").defaultReturn("false");
            }
            case MethodCall: 
            case ReturnMethodCall: {
                return builder;
            }
            case NullableVariable: {
                return builder.defaultReturn(dependencies.outputVariables.get(0).getName()).specialExits(dependencies.exitGroups.get((int)0).statements, "return null;");
            }
            case NullableExitVariable: {
                return builder.defaultReturn("null");
            }
        }
        throw new IllegalArgumentException("Unsupported return mode: " + (Object)((Object)returnMode));
    }

    private static PsiType findReturnType(ReturnMode returnMode, FlowDependency dependency) {
        switch (returnMode) {
            case MethodCall: {
                return PsiType.VOID;
            }
            case NullableVariable: {
                return MethodExtractor.getBoxedTypeOf(dependency.outputVariables.get(0));
            }
            case ConditionalExit: {
                return PsiType.BOOLEAN;
            }
            case Variable: {
                return dependency.outputTypes.get(0);
            }
            case NullableExitVariable: {
                return MethodExtractor.getBoxedTypeOf(MethodExtractor.findNotNullReturn(dependency.exitGroups.get((int)0).statements));
            }
            case ReturnMethodCall: {
                return MethodExtractor.findNotNullReturn(dependency.exitGroups.get((int)0).statements).getType();
            }
        }
        throw new IllegalArgumentException();
    }

    private static PsiExpression findNotNullReturn(List<PsiStatement> returnStatements) {
        return returnStatements.stream().map(returnStatement -> ((PsiReturnStatement)returnStatement).getReturnValue()).filter(returnValue -> returnValue != null && returnValue.getType() != PsiType.NULL).findFirst().orElseThrow(() -> new IllegalStateException());
    }

    private static PsiType getBoxedTypeOf(PsiExpression expression2) {
        return MethodExtractor.boxTypeIfPossible(expression2.getType(), (PsiElement)expression2);
    }

    private static PsiType getBoxedTypeOf(PsiVariable variable) {
        return MethodExtractor.boxTypeIfPossible(variable.getType(), (PsiElement)variable);
    }

    private static PsiType boxTypeIfPossible(PsiType type2, PsiElement context) {
        if (type2 instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type2).getBoxedType(context);
        }
        return type2;
    }

    private static ReturnMode findReturnMode(FlowDependency dependencies) {
        int outVars = dependencies.outputVariables.size();
        int exitGroups = dependencies.exitGroups.size();
        if (outVars > 1) {
            return ReturnMode.MultipleVariables;
        }
        if (outVars == 1) {
            if (exitGroups > 1) {
                return ReturnMode.MultipleVariables;
            }
            if (exitGroups == 0) {
                return ReturnMode.Variable;
            }
            if (exitGroups == 1) {
                boolean isNotNullOutVariable = FlowDependency.hasOnlyNotNullAssignments(dependencies.outputVariables.get(0), dependencies.fragment);
                boolean areExitsSame = dependencies.exitGroups.get(0).areEffectivelySame();
                return isNotNullOutVariable && areExitsSame ? ReturnMode.NullableVariable : ReturnMode.MultipleVariables;
            }
        }
        if (exitGroups > 1) {
            return ReturnMode.MultipleVariables;
        }
        if (exitGroups == 0) {
            return ReturnMode.MethodCall;
        }
        if (exitGroups == 1) {
            StatementGroup exitGroup = dependencies.exitGroups.get(0);
            if (!dependencies.canCompleteNormally || dependencies.hasSingleExit) {
                PsiStatement exitStatement = exitGroup.statements.get(0);
                if (exitStatement instanceof PsiReturnStatement && ((PsiReturnStatement)exitStatement).getReturnValue() != null) {
                    return ReturnMode.ReturnMethodCall;
                }
                return ReturnMode.MethodCall;
            }
            if (exitGroup.areEffectivelySame()) {
                return dependencies.returnsLocalVariable ? ReturnMode.NullableExitVariable : ReturnMode.ConditionalExit;
            }
            List returns = ContainerUtil.map(exitGroup.statements, statement -> (PsiReturnStatement)statement);
            return FlowDependency.hasOnlyNotNullReturns(dependencies.fragment, returns) ? ReturnMode.NullableExitVariable : ReturnMode.MultipleVariables;
        }
        throw new IllegalStateException();
    }

    private static List<String> createDefaultParameterNames(FlowDependency dependencies) {
        return MethodExtractor.createParameterNames(dependencies.inputVariables);
    }

    private static List<String> createParameterNames(List<PsiVariable> inputVariables) {
        return ContainerUtil.map(inputVariables, variable -> variable.getName());
    }

    static enum ReturnMode {
        MethodCall,
        ReturnMethodCall,
        Variable,
        NullableVariable,
        ConditionalExit,
        NullableExitVariable,
        MultipleVariables;

    }
}

