/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl.structures;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.extractMethod.newImpl.ControlFlowOnFragment;
import com.intellij.refactoring.extractMethod.newImpl.structures.CodeFragment;
import com.intellij.refactoring.extractMethod.newImpl.structures.ExpressionGroup;
import com.intellij.refactoring.extractMethod.newImpl.structures.StatementGroup;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowDependency {
    public final CodeFragment fragment;
    public final List<PsiVariable> missedDeclarations;
    public final List<PsiVariable> inputVariables;
    public final List<ExpressionGroup> parameterGroups;
    public final List<PsiType> parameterTypes;
    public final List<PsiVariable> outputVariables;
    public final List<PsiType> outputTypes;
    public final List<StatementGroup> exitGroups;
    public final boolean returnsLocalVariable;
    public final boolean canCompleteNormally;
    public final boolean hasSingleExit;
    public final List<PsiClassType> thrownExceptions;

    public static FlowDependency computeDependency(CodeFragment fragment) {
        return new FlowDependency(fragment);
    }

    private FlowDependency(CodeFragment fragment) {
        ControlFlowOnFragment flowOnFragment = ControlFlowOnFragment.create(fragment);
        this.fragment = fragment;
        this.inputVariables = flowOnFragment.findInputVariables();
        this.parameterTypes = ContainerUtil.map(this.inputVariables, variable -> variable.getType());
        this.parameterGroups = FlowDependency.findInputGroups(this.inputVariables, fragment);
        this.outputVariables = flowOnFragment.findOutputVariables();
        this.outputTypes = ContainerUtil.map(this.outputVariables, variable -> variable.getType());
        List<PsiStatement> exitStatements = flowOnFragment.findExitStatements();
        this.exitGroups = FlowDependency.findExitGroups(exitStatements);
        List<PsiVariable> writtenVariables = flowOnFragment.findWrittenVariables();
        this.missedDeclarations = FlowDependency.findWrittenVariablesWithoutDeclaration(writtenVariables, fragment);
        this.missedDeclarations.removeAll(this.inputVariables);
        this.returnsLocalVariable = FlowDependency.dependsOnVariables(writtenVariables, exitStatements);
        this.canCompleteNormally = flowOnFragment.canCompleteNormally();
        this.hasSingleExit = flowOnFragment.hasSingleExit();
        this.thrownExceptions = FlowDependency.findThrownExceptions(fragment);
    }

    private static List<PsiClassType> findThrownExceptions(CodeFragment fragment) {
        return ExceptionUtil.getThrownCheckedExceptions(fragment.elements.toArray(PsiElement.EMPTY_ARRAY));
    }

    public static boolean hasOnlyNotNullAssignments(final PsiVariable variable, final CodeFragment scope) {
        final boolean[] isNotNull = new boolean[]{true};
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                if (!isNotNull[0]) {
                    return;
                }
                PsiReference reference = assignment.getLExpression().getReference();
                if (reference == null) {
                    return;
                }
                if (reference.isReferenceTo((PsiElement)variable)) {
                    isNotNull[0] = FlowDependency.isNotNull((PsiCodeBlock)scope.getCommonParent(), assignment.getRExpression());
                }
            }
        };
        scope.elements.forEach(it -> it.accept((PsiElementVisitor)visitor2));
        return isNotNull[0];
    }

    public static boolean hasOnlyNotNullReturns(CodeFragment fragment, List<PsiReturnStatement> returns) {
        return returns.stream().allMatch(ret -> FlowDependency.isNotNull((PsiCodeBlock)fragment.getCommonParent(), ret.getReturnValue()));
    }

    private static List<ExpressionGroup> findInputGroups(List<PsiVariable> inputVariables, CodeFragment fragment) {
        return ContainerUtil.map(inputVariables, variable -> FlowDependency.findDependentReferences(variable, fragment));
    }

    private static List<PsiVariable> findWrittenVariablesWithoutDeclaration(Collection<PsiVariable> variables, CodeFragment scope) {
        return ContainerUtil.filter(variables, variable -> !scope.getTextRange().contains(variable.getTextRange()));
    }

    private static List<StatementGroup> findExitGroups(List<PsiStatement> controlStatements) {
        Collection<List<PsiStatement>> statementGroups = controlStatements.stream().collect(Collectors.groupingBy(statement -> statement.getNode().getElementType())).values();
        return ContainerUtil.map(statementGroups, statements -> StatementGroup.of(statements));
    }

    private static ExpressionGroup findDependentReferences(PsiVariable variable, CodeFragment fragment) {
        return ExpressionGroup.of(FlowDependency.findReferencesInFragment(variable, fragment));
    }

    private static List<PsiExpression> findReferencesInFragment(PsiVariable variable, CodeFragment fragment) {
        Stream references = fragment.elements.stream().flatMap(statement -> VariableAccessUtils.getVariableReferences(variable, statement).stream());
        return references.collect(Collectors.toList());
    }

    private static boolean dependsOnVariables(Collection<PsiVariable> variables, List<? extends PsiElement> searchContext) {
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean hasDependentReference = false;
            final /* synthetic */ Collection val$variables;

            Visitor(Collection collection) {
                this.val$variables = collection;
            }

            public void visitReferenceExpression(PsiReferenceExpression reference) {
                super.visitReferenceExpression(reference);
                boolean isDependentReference = this.val$variables.stream().anyMatch(variable -> reference.isReferenceTo((PsiElement)variable));
                if (isDependentReference) {
                    this.hasDependentReference = true;
                }
            }
        }
        Visitor visitor2 = new Visitor(variables);
        for (PsiElement psiElement : searchContext) {
            psiElement.accept((PsiElementVisitor)visitor2);
        }
        return visitor2.hasDependentReference;
    }

    private static boolean isNotNull(PsiCodeBlock block, PsiExpression expr2) {
        Visitor visitor2;
        DataFlowRunner dfaRunner = new DataFlowRunner(block.getProject());
        class Visitor
        extends StandardInstructionVisitor {
            boolean isNotNull = true;
            final /* synthetic */ PsiExpression val$expr;

            Visitor(PsiExpression psiExpression) {
                this.val$expr = psiExpression;
            }

            @Override
            protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
                if (value2 == null) {
                    Visitor.$$$reportNull$$$0(0);
                }
                if (expression2 == null) {
                    Visitor.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
                if (expression2 == this.val$expr) {
                    this.isNotNull = this.isNotNull && state.isNotNull(value2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/refactoring/extractMethod/newImpl/structures/FlowDependency$2Visitor";
                objectArray[2] = "beforeExpressionPush";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        RunnerResult rc = dfaRunner.analyzeCodeBlock(block, visitor2 = new Visitor(expr2));
        return rc == RunnerResult.OK && visitor2.isNotNull;
    }
}

