/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.DuplicateNode;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.refactoring.extractMethod.preview.PatternNode;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class PreviewTreeModel
extends DefaultTreeModel {
    private final DefaultMutableTreeNode myDuplicatesGroup;
    private final DefaultMutableTreeNode myMethodGroup;
    private final PatternNode myPatternNode;
    private boolean myValid;

    PreviewTreeModel(@NotNull ExtractMethodProcessor processor) {
        if (processor == null) {
            PreviewTreeModel.$$$reportNull$$$0(0);
        }
        super(new DefaultMutableTreeNode(""));
        this.setValidImpl(true);
        DefaultMutableTreeNode root = this.getRoot();
        this.myMethodGroup = new DefaultMutableTreeNode(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.group.method", (Object[])new Object[0]));
        root.add(this.myMethodGroup);
        PsiMethod emptyMethod = processor.generateEmptyMethod(processor.getMethodName(), (PsiElement)processor.getTargetClass());
        this.myMethodGroup.add(new MethodNode(emptyMethod));
        DefaultMutableTreeNode originalGroup = new DefaultMutableTreeNode(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.group.original", (Object[])new Object[0]));
        root.add(originalGroup);
        PsiElement[] elements = processor.getElements();
        this.myPatternNode = new PatternNode(elements);
        originalGroup.add(this.myPatternNode);
        List<Match> duplicates = processor.getAnyDuplicates();
        if (!ContainerUtil.isEmpty(duplicates)) {
            this.myDuplicatesGroup = new DefaultMutableTreeNode(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.group.duplicates", (Object[])new Object[0]));
            root.add(this.myDuplicatesGroup);
            for (Match duplicate : duplicates) {
                this.myDuplicatesGroup.add(new DuplicateNode(duplicate));
            }
        } else {
            this.myDuplicatesGroup = null;
        }
    }

    @Override
    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    @NotNull
    MethodNode updateMethod(PsiMethod method) {
        this.myMethodGroup.removeAllChildren();
        MethodNode methodNode = new MethodNode(method);
        this.myMethodGroup.add(methodNode);
        this.reload(this.myMethodGroup);
        MethodNode methodNode2 = methodNode;
        if (methodNode2 == null) {
            PreviewTreeModel.$$$reportNull$$$0(1);
        }
        return methodNode2;
    }

    @NotNull
    public List<DuplicateNode> getEnabledDuplicates() {
        if (this.myDuplicatesGroup != null && this.myDuplicatesGroup.getChildCount() != 0) {
            ArrayList<DuplicateNode> duplicates = new ArrayList<DuplicateNode>();
            for (int i = 0; i < this.myDuplicatesGroup.getChildCount(); ++i) {
                DuplicateNode duplicateNode;
                TreeNode node = this.myDuplicatesGroup.getChildAt(i);
                if (!(node instanceof DuplicateNode) || (duplicateNode = (DuplicateNode)node).isExcluded() || !duplicateNode.isValid()) continue;
                duplicates.add(duplicateNode);
            }
            ArrayList<DuplicateNode> arrayList = duplicates;
            if (arrayList == null) {
                PreviewTreeModel.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        List<DuplicateNode> list = Collections.emptyList();
        if (list == null) {
            PreviewTreeModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<DuplicateNode> getAllDuplicates() {
        if (this.myDuplicatesGroup != null && this.myDuplicatesGroup.getChildCount() != 0) {
            ArrayList<DuplicateNode> duplicates = new ArrayList<DuplicateNode>();
            for (int i = 0; i < this.myDuplicatesGroup.getChildCount(); ++i) {
                TreeNode node = this.myDuplicatesGroup.getChildAt(i);
                if (!(node instanceof DuplicateNode)) continue;
                duplicates.add((DuplicateNode)node);
            }
            ArrayList<DuplicateNode> arrayList = duplicates;
            if (arrayList == null) {
                PreviewTreeModel.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List<DuplicateNode> list = Collections.emptyList();
        if (list == null) {
            PreviewTreeModel.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public PatternNode getPatternNode() {
        PatternNode patternNode = this.myPatternNode;
        if (patternNode == null) {
            PreviewTreeModel.$$$reportNull$$$0(6);
        }
        return patternNode;
    }

    public synchronized boolean isValid() {
        return this.myValid;
    }

    private synchronized void setValidImpl(boolean valid) {
        this.myValid = valid;
    }

    public void setValid(boolean valid) {
        this.setValidImpl(valid);
        this.setValid(this.getRoot(), valid);
    }

    private void setValid(TreeNode node, boolean valid) {
        if (node instanceof FragmentNode) {
            ((FragmentNode)node).setValid(valid);
            this.reload(node);
        }
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.setValid(node.getChildAt(i), valid);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/preview/PreviewTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/PreviewTreeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "updateMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledDuplicates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDuplicates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

