/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InheritanceToDelegationHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(InheritanceToDelegationHandler.class);
    private static final MemberInfoBase.Filter<PsiMember> MEMBER_INFO_FILTER = new MemberInfoBase.Filter<PsiMember>(){

        public boolean includeMember(PsiMember element) {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                return !method.hasModifierProperty("static") && !method.hasModifierProperty("private");
            }
            return element instanceof PsiClass && ((PsiClass)element).isInterface();
        }
    };

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(2);
        }
        return !PsiUtil.isModuleFile((PsiFile)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InheritanceToDelegationHandler.getRefactoringName(), (String)"refactoring.replaceInheritWithDelegat");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(5);
        }
        if (elements.length != 1) {
            return;
        }
        PsiClass aClass = (PsiClass)elements[0];
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (aClass.isInterface()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"class.is.interface", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InheritanceToDelegationHandler.getRefactoringName(), (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        if (aClass instanceof JspClass) {
            RefactoringMessageUtil.showNotSupportedForJspClassesError(project, editor, InheritanceToDelegationHandler.getRefactoringName(), "refactoring.replaceInheritWithDelegat");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        PsiClass[] bases = aClass.getSupers();
        String javaLangObject = "java.lang.Object";
        if (bases.length == 0 || bases.length == 1 && "java.lang.Object".equals(bases[0].getQualifiedName())) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"class.does.not.have.base.classes.or.interfaces", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)InheritanceToDelegationHandler.getRefactoringName(), (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        LinkedHashMap<PsiClass, Collection<MemberInfo>> basesToMemberInfos = new LinkedHashMap<PsiClass, Collection<MemberInfo>>();
        for (PsiClass base : bases) {
            if ("java.lang.Object".equals(base.getQualifiedName())) continue;
            basesToMemberInfos.put(base, InheritanceToDelegationHandler.createBaseClassMemberInfos(base));
        }
        Set baseClasses = ((HashMap)basesToMemberInfos).keySet();
        new InheritanceToDelegationDialog(project, aClass, baseClasses.toArray(PsiClass.EMPTY_ARRAY), basesToMemberInfos).show();
    }

    private static List<MemberInfo> createBaseClassMemberInfos(PsiClass baseClass) {
        PsiClass deepestBase = RefactoringHierarchyUtil.getDeepestNonObjectBase(baseClass);
        LOG.assertTrue(deepestBase != null);
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(baseClass, MEMBER_INFO_FILTER);
        ArrayList<MemberInfo> memberInfoList = new ArrayList<MemberInfo>();
        memberInfoList.addAll(memberInfoStorage.getClassMemberInfos((PsiElement)deepestBase));
        memberInfoList.addAll(memberInfoStorage.getIntermediateMemberInfosList((PsiElement)deepestBase));
        return memberInfoList;
    }

    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"replace.inheritance.with.delegation.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

