/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodDialog;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineMethodSpecialization;
import com.intellij.refactoring.inline.InlineObjectProcessor;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import java.util.Collections;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class InlineMethodHandler
extends JavaInlineActionHandler {
    private InlineMethodHandler() {
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiMethod && element.getNavigationElement() instanceof PsiMethod && element.getLanguage() == JavaLanguage.INSTANCE;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        InlineMethodHandler.performInline(project, editor, (PsiMethod)element.getNavigationElement(), false);
    }

    public static void performInline(Project project, Editor editor, PsiMethod method, boolean allowInlineThisOnly) {
        PsiElement referenceElement;
        boolean invokedOnReference;
        PsiElement refElement;
        String errorMessage;
        String message2;
        PsiElement refElement2;
        PsiReference reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        PsiCodeBlock methodBody2 = method.getBody();
        Supplier<PsiCodeBlock> specialization = InlineMethodSpecialization.forReference(reference);
        if (specialization != null) {
            allowInlineThisOnly = true;
            methodBody2 = specialization.get();
        }
        if (methodBody2 == null) {
            String message3 = method.hasModifierProperty("abstract") ? JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.to.abstract.methods", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()}) : (method.hasModifierProperty("native") ? JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.to.native.methods", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()}) : JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.no.sources.attached", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineMethod");
            return;
        }
        if (reference != null && !InlineMethodHandler.isJavaLanguage((refElement2 = reference.getElement()).getLanguage())) {
            String message4 = JavaRefactoringBundle.message((String)"refactoring.is.not.supported.for.language", (Object[])new Object[]{"Inline of Java method", refElement2.getLanguage().getDisplayName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineMethod");
            return;
        }
        if (reference == null && InlineMethodHandler.checkRecursive(method)) {
            message2 = RefactoringBundle.message((String)"refactoring.is.not.supported.for.recursive.methods", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineMethod");
            return;
        }
        if (reference != null && (errorMessage = InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody2, reference.getElement())) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineMethod");
            return;
        }
        if (method.isConstructor()) {
            if (method.isVarArgs()) {
                message2 = JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.to.vararg.constructors", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineConstructor");
                return;
            }
            boolean chainingConstructor = InlineUtil.isChainingConstructor(method);
            if (!chainingConstructor) {
                InlineObjectProcessor processor = InlineObjectProcessor.create(reference, method);
                if (processor != null) {
                    if (Messages.showOkCancelDialog((String)JavaRefactoringBundle.message((String)"inline.method.object.suggestion.message", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"inline.method.object.action.name", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"inline.action.name", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
                        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
                        processor.run();
                    }
                    return;
                }
                if (!InlineMethodHandler.isThisReference(reference)) {
                    String message5 = JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.to.inline.non.chaining.constructors", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()});
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineConstructor");
                    return;
                }
                allowInlineThisOnly = true;
            }
            if (reference != null) {
                PsiCall constructorCall;
                refElement = reference.getElement();
                PsiCall psiCall = constructorCall = refElement instanceof PsiJavaCodeReferenceElement ? RefactoringUtil.getEnclosingConstructorCall((PsiJavaCodeReferenceElement)refElement) : null;
                if (constructorCall == null || !method.equals(constructorCall.resolveMethod())) {
                    reference = null;
                }
            }
        } else if (reference != null && !method.getManager().areElementsEquivalent((PsiElement)method, reference.resolve())) {
            reference = null;
        }
        if (reference != null && PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStaticStatement.class) != null) {
            reference = null;
        }
        boolean bl = invokedOnReference = reference != null;
        if (!invokedOnReference) {
            VirtualFile vFile = method.getContainingFile().getVirtualFile();
            ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(vFile));
        }
        refElement = null;
        if (reference != null && (referenceElement = reference.getElement()) instanceof PsiJavaCodeReferenceElement) {
            refElement = (PsiJavaCodeReferenceElement)referenceElement;
        }
        InlineMethodDialog dialog = new InlineMethodDialog(project, method, (PsiJavaCodeReferenceElement)refElement, editor, allowInlineThisOnly);
        dialog.show();
    }

    public static boolean checkRecursive(PsiMethod method) {
        return InlineMethodHandler.checkCalls((PsiElement)method.getBody(), method);
    }

    private static boolean checkCalls(PsiElement scope, PsiMethod method) {
        PsiMethod refMethod;
        if (scope instanceof PsiMethodCallExpression && method.equals(refMethod = (PsiMethod)((PsiMethodCallExpression)scope).getMethodExpression().resolve())) {
            return true;
        }
        if (scope instanceof PsiMethodReferenceExpression && method.equals(((PsiMethodReferenceExpression)scope).resolve())) {
            return true;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!InlineMethodHandler.checkCalls(child, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThisReference(PsiReference reference) {
        PsiElement referenceElement;
        return reference != null && (referenceElement = reference.getElement()) instanceof PsiJavaCodeReferenceElement && referenceElement.getParent() instanceof PsiMethodCallExpression && "this".equals(((PsiJavaCodeReferenceElement)referenceElement).getReferenceName());
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return InlineMethodHandler.getRefactoringName() + "...";
    }

    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.method.title");
    }
}

