/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.AbstractInplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceIntroduceConstantPopup
extends AbstractInplaceIntroduceFieldPopup {
    private final String myInitializerText;
    private JCheckBox myReplaceAllCb;
    private JCheckBox myMoveToAnotherClassCb;
    private String myVisibility;

    public InplaceIntroduceConstantPopup(Project project, Editor editor, PsiClass parentClass, PsiExpression expr2, PsiLocalVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, PsiElement anchorElement, PsiElement anchorElementIfAll, OccurrenceManager occurrenceManager) {
        super(project, editor, expr2, (PsiVariable)localVariable, occurrences, typeSelectorManager, IntroduceConstantHandler.getRefactoringNameText(), parentClass, anchorElement, occurrenceManager, anchorElementIfAll);
        this.myInitializerText = InplaceIntroduceConstantPopup.getExprText(expr2, localVariable);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        this.myWholePanel.add((Component)this.getPreviewComponent(), gc);
        gc.gridy = 1;
        this.myWholePanel.add((Component)this.createRightPanel(), gc);
        gc.gridy = 2;
        this.myWholePanel.add((Component)this.createLeftPanel(), gc);
    }

    @Nullable
    private static String getExprText(PsiExpression expr2, PsiLocalVariable localVariable) {
        String exprText;
        String string = exprText = expr2 != null ? expr2.getText() : null;
        if (localVariable != null) {
            PsiExpression initializer = localVariable.getInitializer();
            return initializer != null ? initializer.getText() : exprText;
        }
        return exprText;
    }

    private JPanel createRightPanel() {
        JPanel right = new JPanel(new GridBagLayout());
        GridBagConstraints rgc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0);
        this.myReplaceAllCb = new JCheckBox(RefactoringBundle.message((String)"replace.all.occurences.checkbox"));
        this.myReplaceAllCb.setMnemonic('a');
        this.myReplaceAllCb.setFocusable(false);
        this.myReplaceAllCb.setVisible(((PsiExpression[])this.myOccurrences).length > 1);
        right.add((Component)this.myReplaceAllCb, rgc);
        return right;
    }

    private JPanel createLeftPanel() {
        JPanel left = new JPanel(new GridBagLayout());
        this.myMoveToAnotherClassCb = new JCheckBox(JavaRefactoringBundle.message((String)"introduce.constant.move.to.another.class.checkbox", (Object[])new Object[0]), JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS);
        this.myMoveToAnotherClassCb.setMnemonic('m');
        this.myMoveToAnotherClassCb.setFocusable(false);
        left.add((Component)this.myMoveToAnotherClassCb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return left;
    }

    @NotNull
    private String getSelectedVisibility() {
        if (this.getParentClass() != null && this.getParentClass().isInterface()) {
            return "public";
        }
        String initialVisibility = JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY;
        if (initialVisibility == null) {
            initialVisibility = "public";
        } else {
            String effectiveVisibility = IntroduceConstantDialog.getEffectiveVisibility(initialVisibility, (PsiExpression[])this.myOccurrences, this.getParentClass(), this.myProject);
            if (effectiveVisibility != null) {
                String string = effectiveVisibility;
                if (string == null) {
                    InplaceIntroduceConstantPopup.$$$reportNull$$$0(0);
                }
                return string;
            }
        }
        String string = initialVisibility;
        if (string == null) {
            InplaceIntroduceConstantPopup.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(String[] names2, PsiType psiType) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        return (PsiVariable)WriteAction.compute(() -> {
            PsiElement anchorElementIfAll;
            PsiElement finalAnchorElement;
            PsiClass parentClass = this.getParentClass();
            PsiField field = elementFactory.createFieldFromText(psiType.getCanonicalText() + " " + this.chooseName(names2, parentClass.getLanguage()) + " = " + this.myInitializerText + ";", (PsiElement)parentClass);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            this.myVisibility = this.getSelectedVisibility();
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)this.myVisibility, (boolean)true);
            for (finalAnchorElement = anchorElementIfAll = this.getAnchorElementIfAll(); finalAnchorElement != null && finalAnchorElement.getParent() != parentClass; finalAnchorElement = finalAnchorElement.getParent()) {
            }
            PsiMember anchorMember = finalAnchorElement instanceof PsiMember ? (PsiMember)finalAnchorElement : null;
            field = BaseExpressionToFieldHandler.ConvertToFieldRunnable.appendField((PsiExpression)this.myExpr, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, parentClass, parentClass, field, anchorMember);
            this.myFieldRangeStart = this.myEditor.getDocument().createRangeMarker(field.getTextRange());
            return field;
        });
    }

    @Override
    protected String[] suggestNames(PsiType defaultType, String propName) {
        return IntroduceConstantDialog.createNameSuggestionGenerator((String)propName, (PsiExpression)(this.myExpr != null && ((PsiExpression)this.myExpr).isValid() ? (PsiExpression)this.myExpr : null), (JavaCodeStyleManager)JavaCodeStyleManager.getInstance((Project)this.myProject), null, (PsiClass)this.getParentClass()).getSuggestedNameInfo((PsiType)defaultType).names;
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.STATIC_FINAL_FIELD;
    }

    public boolean isReplaceAllOccurrences() {
        return this.myReplaceAllCb.isSelected();
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
        this.myReplaceAllCb.setSelected(allOccurrences);
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            InplaceIntroduceConstantPopup.$$$reportNull$$$0(2);
        }
        super.saveSettings(psiVariable);
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY = this.myVisibility;
    }

    protected boolean performRefactoring() {
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS = this.myMoveToAnotherClassCb.isSelected();
        if (this.myMoveToAnotherClassCb.isSelected()) {
            this.myEditor.putUserData(INTRODUCE_RESTART, (Object)true);
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myEditor.putUserData(ACTIVE_INTRODUCE, (Object)this);
                try {
                    IntroduceConstantHandler constantHandler = new IntroduceConstantHandler();
                    PsiLocalVariable localVariable = (PsiLocalVariable)this.getLocalVariable();
                    if (localVariable != null) {
                        constantHandler.invokeImpl(this.myProject, localVariable, this.myEditor);
                    } else {
                        constantHandler.invokeImpl(this.myProject, (PsiExpression)this.myExpr, this.myEditor);
                    }
                }
                finally {
                    this.myEditor.putUserData(INTRODUCE_RESTART, (Object)false);
                    this.myEditor.putUserData(ACTIVE_INTRODUCE, null);
                    this.releaseResources();
                    if (this.myLocalMarker != null) {
                        this.myLocalMarker.dispose();
                    }
                    if (this.myExprMarker != null) {
                        this.myExprMarker.dispose();
                    }
                }
            }, this.myProject.getDisposed());
            return false;
        }
        return super.performRefactoring();
    }

    protected String getRefactoringId() {
        return "refactoring.extractConstant";
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return handler instanceof IntroduceConstantHandler && super.startsOnTheSameElement(handler, element);
    }

    protected boolean startsOnTheSameElements(Editor editor, RefactoringActionHandler handler, PsiElement[] elements) {
        PsiReference reference;
        PsiVariable variable;
        if (elements.length == 0 && handler instanceof IntroduceConstantHandler && (variable = this.getVariable()) != null && (reference = TargetElementUtil.findReference((Editor)editor)) instanceof PsiReferenceExpression && reference.resolve() == null && Comparing.strEqual((String)variable.getName(), (String)((PsiReferenceExpression)reference).getReferenceName())) {
            return true;
        }
        return elements.length == 1 && this.startsOnTheSameElement(handler, elements[0]);
    }

    protected void performIntroduce() {
        BaseExpressionToFieldHandler.Settings settings = new BaseExpressionToFieldHandler.Settings(this.getInputName(), (PsiExpression)this.getExpr(), (PsiExpression[])this.getOccurrences(), this.isReplaceAllOccurrences(), true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, this.myVisibility, (PsiLocalVariable)this.getLocalVariable(), this.getType(), true, this.getParentClass(), false, false);
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).withGroupId(this.getCommandName()).run(() -> {
            if (this.getLocalVariable() != null) {
                LocalToFieldHandler.IntroduceFieldRunnable fieldRunnable = new LocalToFieldHandler.IntroduceFieldRunnable(false, (PsiLocalVariable)this.getLocalVariable(), this.getParentClass(), settings, true, (PsiExpression[])this.myOccurrences);
                fieldRunnable.run();
            } else {
                BaseExpressionToFieldHandler.ConvertToFieldRunnable convertToFieldRunnable = new BaseExpressionToFieldHandler.ConvertToFieldRunnable((PsiExpression)this.myExpr, settings, settings.getForcedType(), (PsiExpression[])this.myOccurrences, this.myOccurrenceManager, this.getAnchorElementIfAll(), this.getAnchorElement(), this.myEditor, this.getParentClass());
                convertToFieldRunnable.run();
            }
        });
    }

    protected JComponent getComponent() {
        this.myReplaceAllCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InplaceIntroduceConstantPopup.this.restartInplaceIntroduceTemplate();
            }
        });
        return this.myWholePanel;
    }

    protected String getActionName() {
        return "IntroduceConstant";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceField/InplaceIntroduceConstantPopup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVisibility";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceField/InplaceIntroduceConstantPopup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

