/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.rename.JavaUnresolvableLocalCollisionDetector;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.util.containers.MultiMap;
import java.util.HashSet;

public class InputValidator
implements IntroduceVariableBase.Validator {
    private final Project myProject;
    private final PsiElement myAnchorStatementIfAll;
    private final PsiElement myAnchorStatement;
    private final ExpressionOccurrenceManager myOccurenceManager;
    private final IntroduceVariableBase myIntroduceVariableBase;

    @Override
    public boolean isOK(IntroduceVariableSettings settings) {
        String name2 = settings.getEnteredName();
        boolean replaceAllOccurrences = settings.isReplaceAllOccurrences();
        PsiElement anchor = replaceAllOccurrences ? this.myAnchorStatementIfAll : this.myAnchorStatement;
        PsiElement scope = anchor.getParent();
        if (scope == null) {
            return true;
        }
        final MultiMap conflicts = new MultiMap();
        final HashSet reportedVariables = new HashSet();
        JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor visitor2 = new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor(){

            @Override
            public void visitCollidingElement(PsiVariable collidingVariable) {
                if (!reportedVariables.contains(collidingVariable)) {
                    reportedVariables.add(collidingVariable);
                    String message2 = JavaRefactoringBundle.message((String)"introduced.variable.will.conflict.with.0", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)collidingVariable, (boolean)true)});
                    conflicts.putValue((Object)collidingVariable, (Object)message2);
                }
            }
        };
        JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions(anchor, name2, scope, anchor, visitor2);
        if (replaceAllOccurrences) {
            PsiExpression[] occurences;
            for (PsiExpression occurence : occurences = this.myOccurenceManager.getOccurrences()) {
                IntroduceVariableBase.checkInLoopCondition(occurence, (MultiMap<PsiElement, String>)conflicts);
            }
        } else {
            IntroduceVariableBase.checkInLoopCondition(this.myOccurenceManager.getMainOccurence(), (MultiMap<PsiElement, String>)conflicts);
        }
        if (conflicts.size() > 0) {
            return this.myIntroduceVariableBase.reportConflicts((MultiMap<PsiElement, String>)conflicts, this.myProject, settings);
        }
        return true;
    }

    public InputValidator(IntroduceVariableBase introduceVariableBase, Project project, PsiElement anchorStatementIfAll, PsiElement anchorStatement, ExpressionOccurrenceManager occurenceManager) {
        this.myIntroduceVariableBase = introduceVariableBase;
        this.myProject = project;
        this.myAnchorStatementIfAll = anchorStatementIfAll;
        this.myAnchorStatement = anchorStatement;
        this.myOccurenceManager = occurenceManager;
    }
}

