/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ReassignVariableUtil {
    static final Key<SmartPsiElementPointer<PsiDeclarationStatement>> DECLARATION_KEY = Key.create((String)"var.type");
    static final Key<RangeMarker[]> OCCURRENCES_KEY = Key.create((String)"occurrences");

    private ReassignVariableUtil() {
    }

    @VisibleForTesting
    public static boolean reassign(Editor editor) {
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)editor.getUserData(DECLARATION_KEY);
        PsiDeclarationStatement declaration2 = pointer != null ? (PsiDeclarationStatement)pointer.getElement() : null;
        PsiType type2 = ReassignVariableUtil.getVariableType(declaration2);
        if (type2 != null) {
            VariablesProcessor proc = ReassignVariableUtil.findVariablesOfType(declaration2, type2);
            if (proc.size() > 0) {
                ArrayList<PsiVariable> vars = new ArrayList<PsiVariable>();
                for (int i = 0; i < proc.size(); ++i) {
                    PsiVariable variable = proc.getResult(i);
                    PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
                    if (outerCodeBlock == null || !ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(outerCodeBlock)).forEach(reference -> {
                        PsiElement element = reference.getElement();
                        if (element != null) {
                            return HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, element) == null;
                        }
                        return true;
                    })) continue;
                    vars.add(variable);
                }
                if (vars.isEmpty()) {
                    return true;
                }
                if (vars.size() == 1) {
                    ReassignVariableUtil.replaceWithAssignment(declaration2, proc.getResult(0), editor);
                    return true;
                }
                JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(vars).setTitle(JavaRefactoringBundle.message((String)"introduce.local.variable.to.reassign.title", (Object[])new Object[0])).setRequestFocus(true).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value2, index) -> {
                    if (value2 != null) {
                        label.setText(value2.getName());
                        label.setIcon(value2.getIcon(0));
                    }
                })).setItemChosenCallback(selectedValue -> ReassignVariableUtil.replaceWithAssignment(declaration2, selectedValue, editor)).createPopup();
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    popup.showInBestPositionFor(editor);
                } else {
                    VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
                    Point point = editor.visualPositionToXY(new VisualPosition(visualPosition.line + 1, visualPosition.column));
                    popup.show(new RelativePoint((Component)editor.getContentComponent(), point));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    static PsiType getVariableType(@Nullable PsiDeclarationStatement declaration2) {
        PsiElement[] declaredElements;
        if (declaration2 != null && (declaredElements = declaration2.getDeclaredElements()).length > 0 && declaredElements[0] instanceof PsiVariable) {
            return ((PsiVariable)declaredElements[0]).getType();
        }
        return null;
    }

    static VariablesProcessor findVariablesOfType(final PsiDeclarationStatement declaration2, final PsiType type2) {
        PsiDeclarationStatement scope;
        VariablesProcessor proc = new VariablesProcessor(false){

            @Override
            protected boolean check(PsiVariable var, ResolveState state) {
                for (PsiElement element : declaration2.getDeclaredElements()) {
                    if (element != var) continue;
                    return false;
                }
                return TypeConversionUtil.isAssignable((PsiType)var.getType(), (PsiType)type2);
            }
        };
        for (scope = declaration2; !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiLambdaExpression || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null) {
            return proc;
        }
        PsiScopesUtil.treeWalkUp(proc, (PsiElement)declaration2, (PsiElement)scope);
        return proc;
    }

    static void replaceWithAssignment(PsiDeclarationStatement declaration2, PsiVariable variable, Editor editor) {
        PsiVariable var = (PsiVariable)declaration2.getDeclaredElements()[0];
        PsiExpression initializer = var.getInitializer();
        WriteCommandAction.writeCommandAction((Project)declaration2.getProject()).run(() -> {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
            String chosenVariableName = variable.getName();
            PsiStatement newDeclaration = elementFactory.createStatementFromText(chosenVariableName + " = " + initializer.getText() + ";", (PsiElement)declaration2);
            Collection references = ReferencesSearch.search((PsiElement)var).findAll();
            newDeclaration = declaration2.replace((PsiElement)newDeclaration);
            for (PsiReference reference : references) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression)) continue;
                element.replace((PsiElement)elementFactory.createExpressionFromText(chosenVariableName, (PsiElement)newDeclaration));
            }
            PsiModifierList modifierList = variable.getModifierList();
            if (modifierList != null) {
                modifierList.setModifierProperty("final", false);
            }
        });
        ReassignVariableUtil.finishTemplate(editor);
    }

    private static void finishTemplate(Editor editor) {
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        InplaceRefactoring renamer = (InplaceRefactoring)editor.getUserData(InplaceRefactoring.INPLACE_RENAMER);
        if (templateState != null && renamer != null) {
            templateState.gotoEnd(true);
            editor.putUserData(InplaceRefactoring.INPLACE_RENAMER, null);
        }
    }
}

