/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.refactoring.introduceparameterobject.ParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ParameterObjectBuilder {
    private String className;
    private String packageName;
    private final List<ParameterSpec> fields = new ArrayList<ParameterSpec>(5);
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private Project myProject;
    private PsiFile myFile;
    private JavaCodeStyleManager myJavaCodeStyleManager;
    private String myVisibility;

    ParameterObjectBuilder() {
    }

    public void setClassName(String className2) {
        this.className = className2;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void addField(PsiParameter variable, String name2, PsiType type2, boolean setterRequired) {
        String propertyName = this.myJavaCodeStyleManager.variableNameToPropertyName(name2, VariableKind.PARAMETER);
        ParameterSpec field = new ParameterSpec(variable, this.myJavaCodeStyleManager.propertyNameToVariableName(propertyName, VariableKind.FIELD), type2 instanceof PsiEllipsisType ? ((PsiEllipsisType)type2).toArrayType() : type2, setterRequired);
        this.fields.add(field);
    }

    public void setTypeArguments(Collection<PsiTypeParameter> typeParams) {
        this.typeParams.clear();
        this.typeParams.addAll(typeParams);
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
    }

    public void setFile(@NotNull PsiFile file) {
        if (file == null) {
            ParameterObjectBuilder.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    public String buildBeanClass() {
        StringBuffer out = new StringBuffer(1024);
        if (this.packageName.length() > 0) {
            out.append("package " + this.packageName + ';');
        }
        out.append('\n');
        out.append(this.myVisibility + " class " + this.className);
        if (!this.typeParams.isEmpty()) {
            out.append('<');
            boolean first = true;
            for (PsiTypeParameter typeParam : this.typeParams) {
                if (!first) {
                    out.append(',');
                }
                out.append(typeParam.getText());
                first = false;
            }
            out.append('>');
        }
        out.append('\n');
        out.append('{');
        this.outputFields(out);
        this.outputConstructor(out);
        this.outputGetters(out);
        this.outputSetters(out);
        out.append("}\n");
        return out.toString();
    }

    private void outputSetters(StringBuffer out) {
        for (ParameterSpec field : this.fields) {
            this.outputSetter(field, out);
        }
    }

    private void outputGetters(StringBuffer out) {
        for (ParameterSpec field : this.fields) {
            this.outputGetter(field, out);
        }
    }

    private void outputFields(StringBuffer out) {
        for (ParameterSpec field : this.fields) {
            this.outputField(field, out);
        }
    }

    private void outputSetter(ParameterSpec field, @NonNls StringBuffer out) {
        if (!field.isSetterRequired()) {
            return;
        }
        out.append(GenerateMembersUtil.generateSetterPrototype(JavaPsiFacade.getElementFactory((Project)this.myProject).createField(field.getName(), field.getType())).getText());
    }

    private static void generateFieldAssignment(StringBuffer out, String parameterName, String fieldName) {
        if (fieldName.equals(parameterName)) {
            out.append("\t\tthis." + fieldName + " = " + parameterName + ";\n");
        } else {
            out.append("\t\t" + fieldName + " = " + parameterName + ";\n");
        }
    }

    private void outputGetter(ParameterSpec field, @NonNls StringBuffer out) {
        out.append(GenerateMembersUtil.generateGetterPrototype(JavaPsiFacade.getElementFactory((Project)this.myProject).createField(field.getName(), field.getType())).getText());
    }

    @NotNull
    private CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.myFile != null ? CodeStyle.getSettings((PsiFile)this.myFile) : CodeStyle.getProjectOrDefaultSettings((Project)this.myProject);
        if (codeStyleSettings == null) {
            ParameterObjectBuilder.$$$reportNull$$$0(1);
        }
        return codeStyleSettings;
    }

    private void outputConstructor(@NonNls StringBuffer out) {
        out.append("\t" + this.myVisibility + " " + this.className + '(');
        Iterator<ParameterSpec> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ParameterSpec field = iterator.next();
            PsiParameter parameter2 = field.getParameter();
            this.outputAnnotationString(parameter2, out);
            out.append(((JavaCodeStyleSettings)this.getSettings().getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS ? " final " : "");
            String parameterName = parameter2.getName();
            PsiType type2 = field.getType();
            PsiType fieldType = parameter2.isVarArgs() && type2 instanceof PsiArrayType ? new PsiEllipsisType(((PsiArrayType)type2).getComponentType()) : type2;
            out.append(' ' + fieldType.getCanonicalText() + ' ' + parameterName);
            if (!iterator.hasNext()) continue;
            out.append(", ");
        }
        out.append(")\n");
        out.append("\t{\n");
        for (ParameterSpec field : this.fields) {
            ParameterObjectBuilder.generateFieldAssignment(out, field.getParameter().getName(), field.getName());
        }
        out.append("\t}\n");
    }

    private void outputField(ParameterSpec field, StringBuffer out) {
        PsiParameter parameter2 = field.getParameter();
        PsiDocComment docComment = ParameterObjectBuilder.getJavadocForVariable((PsiVariable)parameter2);
        if (docComment != null) {
            out.append(docComment.getText());
            out.append('\n');
        }
        PsiType type2 = field.getType();
        String typeText = type2.getCanonicalText();
        String name2 = field.getName();
        String modifierString = "private ";
        if (!field.isSetterRequired()) {
            modifierString = modifierString + "final ";
        }
        this.outputAnnotationString(parameter2, out);
        out.append('\t' + modifierString + typeText + ' ' + name2 + ";\n");
    }

    private void outputAnnotationString(PsiParameter parameter2, StringBuffer out) {
        PsiAnnotation[] annotations;
        PsiModifierList modifierList = parameter2.getModifierList();
        for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
            PsiClass annotationClass;
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null || (annotationClass = (PsiClass)reference.resolve()) == null) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            String annotationText = '@' + annotationClass.getQualifiedName() + parameterList.getText();
            out.append(annotationText);
        }
    }

    private static PsiDocComment getJavadocForVariable(PsiVariable variable) {
        PsiElement[] children;
        for (PsiElement child : children = variable.getChildren()) {
            if (!(child instanceof PsiDocComment)) continue;
            return (PsiDocComment)child;
        }
        return null;
    }

    public void setVisibility(String visibility) {
        this.myVisibility = visibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceparameterobject/ParameterObjectBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceparameterobject/ParameterObjectBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFile";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

