/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.SelfUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class MakeStaticUtil {
    public static InternalUsageInfo[] findClassRefsInMember(PsiTypeParameterListOwner member, boolean includeSelf) {
        PsiClass containingClass = member.getContainingClass();
        ArrayList classRefs = new ArrayList();
        MakeStaticUtil.addClassRefs(member, classRefs, containingClass, (PsiElement)member, includeSelf);
        return classRefs.toArray(new InternalUsageInfo[0]);
    }

    public static boolean isParameterNeeded(PsiTypeParameterListOwner member) {
        return MakeStaticUtil.findClassRefsInMember(member, false).length > 0;
    }

    private static void addClassRefs(PsiTypeParameterListOwner originalMember, ArrayList<? super InternalUsageInfo> classRefs, PsiClass containingClass, PsiElement element, boolean includeSelf) {
        PsiElement[] children;
        PsiClass hisClass;
        PsiJavaCodeReferenceElement classReference2;
        PsiElement refElement;
        PsiJavaCodeReferenceElement qualifier;
        if (element instanceof PsiReferenceExpression) {
            PsiElement resolved;
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            if (!ref.isQualified() && (resolved = ref.resolve()) instanceof PsiMember && !((PsiMember)resolved).hasModifierProperty("static")) {
                PsiMember member = (PsiMember)resolved;
                if (originalMember.getManager().areElementsEquivalent((PsiElement)member, (PsiElement)originalMember)) {
                    if (includeSelf) {
                        classRefs.add(new SelfUsageInfo(element, (PsiElement)originalMember));
                    }
                } else {
                    PsiClass memberContainingClass = member.getContainingClass();
                    if (!(originalMember instanceof PsiClass && MakeStaticUtil.isPartOf(memberContainingClass, (PsiClass)originalMember) || !MakeStaticUtil.isPartOf(memberContainingClass, containingClass))) {
                        classRefs.add(new InternalUsageInfo(element, (PsiElement)member));
                    }
                }
            }
        } else if (element instanceof PsiThisExpression) {
            qualifier = ((PsiThisExpression)element).getQualifier();
            PsiElement psiElement = refElement = qualifier != null ? qualifier.resolve() : PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (refElement instanceof PsiClass && !refElement.equals(originalMember) && MakeStaticUtil.isPartOf((PsiClass)refElement, containingClass)) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).isReferenceTo((PsiElement)originalMember)) {
                    if (includeSelf) {
                        classRefs.add(new SelfUsageInfo(parent, (PsiElement)originalMember));
                    }
                } else {
                    classRefs.add(new InternalUsageInfo(element, refElement));
                }
            }
        } else if (element instanceof PsiSuperExpression) {
            qualifier = ((PsiSuperExpression)element).getQualifier();
            PsiElement psiElement = refElement = qualifier != null ? qualifier.resolve() : PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (refElement instanceof PsiClass && MakeStaticUtil.isPartOf((PsiClass)refElement, containingClass) && (!(originalMember instanceof PsiClass) || !MakeStaticUtil.isPartOf((PsiClass)refElement, (PsiClass)originalMember))) {
                classRefs.add(new InternalUsageInfo(element, refElement));
            }
        } else if (element instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)element).getClassReference()) != null && (refElement = classReference2.resolve()) instanceof PsiClass && (hisClass = ((PsiClass)refElement).getContainingClass()) != originalMember && MakeStaticUtil.isPartOf(hisClass, containingClass) && !((PsiClass)refElement).hasModifierProperty("static")) {
            classRefs.add(new InternalUsageInfo(element, refElement));
        }
        for (PsiElement child : children = element.getChildren()) {
            MakeStaticUtil.addClassRefs(originalMember, classRefs, containingClass, child, includeSelf);
        }
    }

    private static boolean isPartOf(PsiClass elementClass, PsiClass containingClass) {
        while (elementClass != null) {
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)elementClass, (boolean)true)) {
                return true;
            }
            if (elementClass.hasModifierProperty("static")) {
                return false;
            }
            elementClass = elementClass.getContainingClass();
        }
        return false;
    }

    public static boolean buildVariableData(PsiTypeParameterListOwner member, ArrayList<? super VariableData> result) {
        InternalUsageInfo[] classRefsInMethod = MakeStaticUtil.findClassRefsInMember(member, false);
        return MakeStaticUtil.collectVariableData((PsiMember)member, classRefsInMethod, result);
    }

    public static boolean collectVariableData(PsiMember member, InternalUsageInfo[] internalUsages, ArrayList<? super VariableData> variableDatum) {
        HashSet<PsiField> reported = new HashSet<PsiField>();
        HashSet<PsiField> accessedForWriting = new HashSet<PsiField>();
        boolean needClassParameter = false;
        for (InternalUsageInfo usage : internalUsages) {
            PsiElement referencedElement = usage.getReferencedElement();
            if (usage.isWriting()) {
                accessedForWriting.add((PsiField)referencedElement);
                needClassParameter = true;
                continue;
            }
            if (referencedElement instanceof PsiField) {
                PsiField field = (PsiField)referencedElement;
                reported.add(field);
                continue;
            }
            needClassParameter = true;
        }
        ArrayList psiFields = new ArrayList(reported);
        Collections.sort(psiFields, (psiField, psiField1) -> psiField.getName().compareTo(psiField1.getName()));
        for (PsiField field : psiFields) {
            if (accessedForWriting.contains(field)) continue;
            VariableData data = new VariableData((PsiVariable)field);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)member.getProject());
            String name2 = field.getName();
            name2 = codeStyleManager.variableNameToPropertyName(name2, VariableKind.FIELD);
            name2 = codeStyleManager.propertyNameToVariableName(name2, VariableKind.PARAMETER);
            data.name = name2 = RefactoringUtil.suggestUniqueVariableName(name2, (PsiElement)member, field);
            data.passAsParameter = true;
            variableDatum.add(data);
        }
        return needClassParameter;
    }
}

