/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPushDown.PushDownDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPushDownHandler
implements RefactoringActionHandler,
ElementsHandler,
ContextAwareActionHandler {
    @Deprecated
    public static final String REFACTORING_NAME = "Push Members Down";

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            JavaPushDownHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaPushDownHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            JavaPushDownHandler.$$$reportNull$$$0(2);
        }
        return !JavaPushDownHandler.getElements(editor, file, (Ref<? super String>)Ref.create(), true).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JavaPushDownHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        Ref errorMessage = Ref.create();
        List<PsiElement> elements = JavaPushDownHandler.getElements(editor, file, (Ref<? super String>)errorMessage, false);
        if (elements.isEmpty()) {
            String message2 = !errorMessage.isNull() ? (String)errorMessage.get() : RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)JavaPushDownHandler.getRefactoringName(), (String)"refactoring.pushMembersDown");
        } else {
            this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
        }
    }

    @NotNull
    private static List<PsiElement> getElements(Editor editor, PsiFile file, Ref<? super String> errorMessage, boolean stopAtCodeBlock) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            int offset = caret.getOffset();
            PsiElement element = file.findElementAt(offset);
            String errorFromElement = JavaPushDownHandler.collectElementsUnderCaret(element, elements, stopAtCodeBlock);
            if (errorFromElement == null) continue;
            errorMessage.set((Object)errorFromElement);
        }
        ArrayList<PsiElement> arrayList = elements;
        if (arrayList == null) {
            JavaPushDownHandler.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static String collectElementsUnderCaret(PsiElement element, List<? super PsiElement> elements, boolean stopAtCodeBlock) {
        while (element != null && !(element instanceof PsiFile)) {
            if (stopAtCodeBlock && element instanceof PsiCodeBlock) {
                return null;
            }
            if (element instanceof PsiClass && ((PsiClass)element).getQualifiedName() != null || element instanceof PsiField || element instanceof PsiMethod) {
                if (element instanceof JspClass) {
                    return RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"refactoring.is.not.supported.for.jsp.classes", (Object[])new Object[0]));
                }
                elements.add((PsiElement)element);
                return null;
            }
            element = element.getParent();
        }
        return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from"));
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        Editor editor;
        PsiClass aClass;
        if (project == null) {
            JavaPushDownHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            JavaPushDownHandler.$$$reportNull$$$0(6);
        }
        if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement[])elements), PsiClass.class, (boolean)false)) == null) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (aClass.hasModifierProperty("final")) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactoringBundle.message((String)"refactoring.cannot.be.performed") + JavaRefactoringBundle.message((String)"class.is.final.warning.message", (Object[])new Object[]{aClass.getName()})), (String)JavaPushDownHandler.getRefactoringName(), (String)"refactoring.pushMembersDown");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(aClass, (MemberInfoBase.Filter<PsiMember>)((MemberInfoBase.Filter)element -> !(element instanceof PsiEnumConstant)));
        List members = memberInfoStorage.getClassMemberInfos((PsiElement)aClass);
        block0: for (MemberInfoBase member : members) {
            for (PsiElement element2 : elements) {
                if (!PsiTreeUtil.isAncestor((PsiElement)member.getMember(), (PsiElement)element2, (boolean)false)) continue;
                member.setChecked(true);
                continue block0;
            }
        }
        PushDownDialog dialog = new PushDownDialog(project, members.toArray(new MemberInfo[0]), aClass);
        dialog.show();
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"push.members.down.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/memberPushDown/JavaPushDownHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/memberPushDown/JavaPushDownHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

