/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingMoveDestination;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutocreatingSingleSourceRootMoveDestination
extends AutocreatingMoveDestination {
    private final VirtualFile mySourceRoot;
    PsiDirectory myTargetDirectory;

    public AutocreatingSingleSourceRootMoveDestination(PackageWrapper targetPackage, @NotNull VirtualFile sourceRoot) {
        if (sourceRoot == null) {
            AutocreatingSingleSourceRootMoveDestination.$$$reportNull$$$0(0);
        }
        super(targetPackage);
        this.mySourceRoot = sourceRoot;
    }

    @Override
    @NotNull
    public PackageWrapper getTargetPackage() {
        PackageWrapper packageWrapper = this.myPackage;
        if (packageWrapper == null) {
            AutocreatingSingleSourceRootMoveDestination.$$$reportNull$$$0(1);
        }
        return packageWrapper;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
    }

    public PsiDirectory getTargetIfExists(@NotNull PsiFile source) {
        if (source == null) {
            AutocreatingSingleSourceRootMoveDestination.$$$reportNull$$$0(2);
        }
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiDirectory source) throws IncorrectOperationException {
        return this.getDirectory();
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiFile source) throws IncorrectOperationException {
        return this.getDirectory();
    }

    @Nullable
    public String verify(PsiFile source) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public String verify(PsiDirectory source) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public String verify(PsiPackage aPackage) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public void analyzeModuleConflicts(@NotNull Collection<? extends PsiElement> elements, @NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
        if (elements == null) {
            AutocreatingSingleSourceRootMoveDestination.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            AutocreatingSingleSourceRootMoveDestination.$$$reportNull$$$0(4);
        }
        RefactoringConflictsUtil.analyzeModuleConflicts(this.getTargetPackage().getManager().getProject(), elements, usages, this.mySourceRoot, conflicts);
    }

    public boolean isTargetAccessible(@NotNull Project project, @NotNull VirtualFile place) {
        if (project == null) {
            AutocreatingSingleSourceRootMoveDestination.$$$reportNull$$$0(5);
        }
        if (place == null) {
            AutocreatingSingleSourceRootMoveDestination.$$$reportNull$$$0(6);
        }
        boolean inTestSourceContent = ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(place);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)place, (Project)project);
        return this.mySourceRoot == null || module == null || GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)inTestSourceContent).contains(this.mySourceRoot);
    }

    private PsiDirectory getDirectory() throws IncorrectOperationException {
        if (this.myTargetDirectory == null) {
            this.myTargetDirectory = (PsiDirectory)WriteAction.compute(() -> {
                try {
                    return RefactoringUtil.createPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
                }
                catch (IncorrectOperationException e) {
                    return null;
                }
            });
        }
        return this.myTargetDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/AutocreatingSingleSourceRootMoveDestination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/AutocreatingSingleSourceRootMoveDestination";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTargetIfExists";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "analyzeModuleConflicts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTargetAccessible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

