/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingMoveDestination;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleRootsMoveDestination
extends AutocreatingMoveDestination {
    private static final Logger LOG = Logger.getInstance(MultipleRootsMoveDestination.class);

    public MultipleRootsMoveDestination(PackageWrapper aPackage) {
        super(aPackage);
    }

    @Override
    @NotNull
    public PackageWrapper getTargetPackage() {
        PackageWrapper packageWrapper = this.myPackage;
        if (packageWrapper == null) {
            MultipleRootsMoveDestination.$$$reportNull$$$0(0);
        }
        return packageWrapper;
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiDirectory source) throws IncorrectOperationException {
        return this.getOrCreateDirectoryForSource(source.getVirtualFile());
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiFile source) throws IncorrectOperationException {
        return this.getOrCreateDirectoryForSource(source.getVirtualFile());
    }

    public PsiDirectory getTargetIfExists(@NotNull PsiFile source) {
        if (source == null) {
            MultipleRootsMoveDestination.$$$reportNull$$$0(1);
        }
        return this.findTargetDirectoryForSource(source.getVirtualFile());
    }

    public String verify(PsiFile source) {
        VirtualFile sourceRootForFile;
        VirtualFile virtualFile = source.getVirtualFile();
        if (virtualFile.isDirectory()) {
            virtualFile = virtualFile.getParent();
            LOG.assertTrue(virtualFile.isDirectory());
        }
        if ((sourceRootForFile = this.myFileIndex.getSourceRootForFile(virtualFile)) == null) {
            return "";
        }
        return this.checkCanCreateInSourceRoot(sourceRootForFile);
    }

    @Nullable
    public String verify(PsiDirectory source) {
        VirtualFile virtualFile = source.getVirtualFile();
        VirtualFile sourceRootForFile = this.myFileIndex.getSourceRootForFile(virtualFile);
        if (sourceRootForFile == null) {
            return "";
        }
        if (virtualFile.equals(sourceRootForFile)) {
            return null;
        }
        return this.checkCanCreateInSourceRoot(sourceRootForFile);
    }

    @Nullable
    public String verify(PsiPackage source) {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = source.getDirectories()) {
            String s = this.verify(directory);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public void analyzeModuleConflicts(@NotNull Collection<? extends PsiElement> elements, @NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
        if (elements == null) {
            MultipleRootsMoveDestination.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            MultipleRootsMoveDestination.$$$reportNull$$$0(3);
        }
    }

    public boolean isTargetAccessible(@NotNull Project project, @NotNull VirtualFile place) {
        if (project == null) {
            MultipleRootsMoveDestination.$$$reportNull$$$0(4);
        }
        if (place == null) {
            MultipleRootsMoveDestination.$$$reportNull$$$0(5);
        }
        return true;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return this.findTargetDirectoryForSource(source.getVirtualFile());
    }

    private PsiDirectory findTargetDirectoryForSource(VirtualFile file) {
        VirtualFile sourceRoot = this.myFileIndex.getSourceRootForFile(file);
        LOG.assertTrue(sourceRoot != null);
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, sourceRoot);
    }

    private PsiDirectory getOrCreateDirectoryForSource(VirtualFile file) throws IncorrectOperationException {
        return RefactoringUtil.createPackageDirectoryInSourceRoot(this.myPackage, Objects.requireNonNull(this.myFileIndex.getSourceRootForFile(file)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/MultipleRootsMoveDestination";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPackage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MultipleRootsMoveDestination";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTargetIfExists";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeModuleConflicts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTargetAccessible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

