/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.JavaMoveClassesOrPackagesHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInnerToUpperHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        return MoveInnerToUpperHandler.isNonStaticInnerClass(element);
    }

    private static boolean isNonStaticInnerClass(PsiElement element) {
        return element instanceof PsiClass && element.getParent() instanceof PsiClass && !((PsiClass)element).hasModifierProperty("static");
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        MoveInnerImpl.doMove(project, elements, callback, targetContainer);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (MoveInnerToUpperHandler.isNonStaticInnerClass(element) && !JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            PsiClass aClass = (PsiClass)element;
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.move.moveInner");
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass instanceof JspClass) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"move.nonstatic.class.from.jsp.not.supported", (Object[])new Object[0]), (String)RefactoringBundle.message((String)"move.title"), null);
                return true;
            }
            MoveInnerImpl.doMove(project, new PsiElement[]{aClass}, null, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext));
            return true;
        }
        return false;
    }

    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveInnerToUpperHandler.$$$reportNull$$$0(0);
        }
        return JavaRefactoringBundle.message((String)"move.inner.class.to.upper.level.action.name", (Object[])new Object[0]);
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            MoveInnerToUpperHandler.$$$reportNull$$$0(1);
        }
        return language instanceof JvmLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveInner/MoveInnerToUpperHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

