/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.makeStatic.MakeStaticHandler;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInstanceMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(MoveInstanceMethodHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            MoveInstanceMethodHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiMethod)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.method", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)MoveInstanceMethodHandler.getRefactoringName(), (String)"refactoring.moveInstMethod");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Move Instance Method invoked");
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            MoveInstanceMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            MoveInstanceMethodHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1 || !(elements[0] instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)elements[0];
        String message2 = null;
        if (!method.getManager().isInProject((PsiElement)method)) {
            message2 = JavaRefactoringBundle.message((String)"move.method.is.not.supported.for.non.project.methods", (Object[])new Object[0]);
        } else if (method.isConstructor()) {
            message2 = JavaRefactoringBundle.message((String)"move.method.is.not.supported.for.constructors", (Object[])new Object[0]);
        } else if (method.getLanguage() != JavaLanguage.INSTANCE) {
            message2 = JavaRefactoringBundle.message((String)"move.method.is.not.supported.for.0", (Object[])new Object[]{method.getLanguage().getDisplayName()});
        } else {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && MoveInstanceMethodHandler.mentionTypeParameters(method)) {
                message2 = JavaRefactoringBundle.message((String)"move.method.is.not.supported.for.generic.classes", (Object[])new Object[0]);
            } else if (method.findSuperMethods().length > 0 || ((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)).length > 0) {
                message2 = RefactoringBundle.message((String)"move.method.is.not.supported.when.method.is.part.of.inheritance.hierarchy");
            } else {
                Set<PsiClass> classes2 = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)method).keySet();
                for (PsiClass aClass : classes2) {
                    if (!(aClass instanceof JspClass)) continue;
                    message2 = JavaRefactoringBundle.message((String)"synthetic.jsp.class.is.referenced.in.the.method", (Object[])new Object[0]);
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)MoveInstanceMethodHandler.getRefactoringName(), (String)"refactoring.moveInstMethod");
                    break;
                }
            }
        }
        if (message2 != null) {
            MoveInstanceMethodHandler.showErrorHint(project, dataContext, message2);
            return;
        }
        ArrayList suitableVariables = new ArrayList();
        message2 = MoveInstanceMethodHandler.collectSuitableVariables(method, suitableVariables);
        if (message2 != null) {
            String unableToMakeStaticMessage = MakeStaticHandler.validateTarget((PsiTypeParameterListOwner)method);
            if (unableToMakeStaticMessage != null) {
                MoveInstanceMethodHandler.showErrorHint(project, dataContext, message2);
            } else {
                String suggestToMakeStaticMessage = "Would you like to make method '" + method.getName() + "' static and then move?";
                if (Messages.showYesNoCancelDialog((Project)project, (String)(message2 + ". " + suggestToMakeStaticMessage), (String)MoveInstanceMethodHandler.getRefactoringName(), (Icon)Messages.getErrorIcon()) == 0) {
                    MakeStaticHandler.invoke((PsiTypeParameterListOwner)method);
                }
            }
            return;
        }
        new MoveInstanceMethodDialog(method, suitableVariables.toArray(new PsiVariable[0])).show();
    }

    private static void showErrorHint(Project project, DataContext dataContext, String message2) {
        Editor editor = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message2), (String)MoveInstanceMethodHandler.getRefactoringName(), (String)"refactoring.moveInstMethod");
    }

    @Nullable
    private static String collectSuitableVariables(PsiMethod method, List<? super PsiVariable> suitableVariables) {
        ArrayList allVariables = new ArrayList();
        ContainerUtil.addAll(allVariables, (Object[])method.getParameterList().getParameters());
        ContainerUtil.addAll(allVariables, (Object[])method.getContainingClass().getFields());
        boolean classTypesFound = false;
        boolean resolvableClassesFound = false;
        boolean classesInProjectFound = false;
        for (PsiVariable variable : allVariables) {
            PsiType type2 = variable.getType();
            if (!(type2 instanceof PsiClassType) || ((PsiClassType)type2).hasParameters()) continue;
            classTypesFound = true;
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            resolvableClassesFound = true;
            boolean inProject = method.getManager().isInProject((PsiElement)psiClass);
            if (!inProject) continue;
            classesInProjectFound = true;
            suitableVariables.add((PsiVariable)variable);
        }
        if (suitableVariables.isEmpty()) {
            if (!classTypesFound) {
                return JavaRefactoringBundle.message((String)"there.are.no.variables.that.have.reference.type", (Object[])new Object[0]);
            }
            if (!resolvableClassesFound) {
                return JavaRefactoringBundle.message((String)"all.candidate.variables.have.unknown.types", (Object[])new Object[0]);
            }
            if (!classesInProjectFound) {
                return JavaRefactoringBundle.message((String)"all.candidate.variables.have.types.not.in.project", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String suggestParameterNameForThisClass(PsiClass thisClass) {
        PsiManager manager = thisClass.getManager();
        PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createType(thisClass);
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)manager.getProject()).suggestVariableName(VariableKind.PARAMETER, null, null, (PsiType)type2);
        return suggestedNameInfo.names.length > 0 ? suggestedNameInfo.names[0] : "";
    }

    public static Map<PsiClass, String> suggestParameterNames(PsiMethod method, PsiVariable targetVariable) {
        Map<PsiClass, Set<PsiMember>> classesToMembers = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)method);
        LinkedHashMap<PsiClass, String> result = new LinkedHashMap<PsiClass, String>();
        for (Map.Entry<PsiClass, Set<PsiMember>> entry : classesToMembers.entrySet()) {
            PsiClass aClass = entry.getKey();
            Set<PsiMember> members = entry.getValue();
            if (members.size() == 1 && members.contains(targetVariable)) continue;
            result.put(aClass, MoveInstanceMethodHandler.suggestParameterNameForThisClass(aClass));
        }
        return result;
    }

    private static boolean mentionTypeParameters(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        HashSet typeParameters = ContainerUtil.newHashSet((Iterable)PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)containingClass));
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            if (!PsiTypesUtil.mentionsTypeParameters((PsiType)parameter2.getType(), (Set)typeParameters)) continue;
            return true;
        }
        return PsiTypesUtil.mentionsTypeParameters((PsiType)method.getReturnType(), (Set)typeParameters);
    }

    static String getRefactoringName() {
        return RefactoringBundle.message((String)"move.instance.method.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

