/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JavaNameSuggestionProvider
implements NameSuggestionProvider {
    @Nullable
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result) {
        PsiElement parentOfParent;
        PsiElement nameSuggestionContextParent;
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return null;
        }
        String initialName = UsageViewUtil.getShortName((PsiElement)element);
        SuggestedNameInfo info = JavaNameSuggestionProvider.suggestNamesForElement(element, nameSuggestionContext);
        if (info != null) {
            info = JavaCodeStyleManager.getInstance((Project)element.getProject()).suggestUniqueVariableName(info, element, true, true);
        }
        String parameterName = null;
        String superMethodName = null;
        if (nameSuggestionContext instanceof PsiParameter && (nameSuggestionContextParent = nameSuggestionContext.getParent()) instanceof PsiParameterList && (parentOfParent = nameSuggestionContextParent.getParent()) instanceof PsiMethod) {
            String propName = PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)parentOfParent));
            if (propName != null) {
                parameterName = propName;
            }
            superMethodName = JavaNameSuggestionProvider.getSuperMethodName((PsiParameter)nameSuggestionContext, (PsiMethod)parentOfParent);
        }
        String[] strings = info != null ? info.names : ArrayUtilRt.EMPTY_STRING_ARRAY;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(strings));
        String[] properlyCased = JavaNameSuggestionProvider.suggestProperlyCasedName(element);
        if (properlyCased != null) {
            Collections.addAll(list, properlyCased);
        }
        if (parameterName != null && !list.contains(parameterName)) {
            list.add(parameterName);
        }
        if (superMethodName != null && !list.contains(superMethodName)) {
            list.add(0, superMethodName);
        }
        list.remove(initialName);
        list.add(initialName);
        ContainerUtil.removeDuplicates(list);
        result.addAll(list);
        return info;
    }

    @Nullable
    private static String getSuperMethodName(PsiParameter psiParameter, PsiMethod method) {
        PsiMethod[] superMethods;
        int index = method.getParameterList().getParameterIndex(psiParameter);
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            PsiParameterList superParameters = superMethod.getParameterList();
            if (index >= superParameters.getParametersCount()) continue;
            return superParameters.getParameters()[index].getName();
        }
        return null;
    }

    private static String @Nullable [] suggestProperlyCasedName(PsiElement psiElement) {
        if (!(psiElement instanceof PsiNamedElement)) {
            return null;
        }
        if (psiElement instanceof PsiFile) {
            return null;
        }
        String name2 = ((PsiNamedElement)psiElement).getName();
        if (name2 == null) {
            return null;
        }
        String prefix = "";
        if (psiElement instanceof PsiVariable) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiElement.getProject());
            VariableKind kind2 = codeStyleManager.getVariableKind((PsiVariable)psiElement);
            prefix = codeStyleManager.getPrefixByVariableKind(kind2);
            if (kind2 == VariableKind.STATIC_FINAL_FIELD) {
                String[] words = NameUtilCore.splitNameIntoWords((String)name2);
                String buffer = Arrays.stream(words).map(StringUtil::toUpperCase).collect(Collectors.joining("_"));
                return new String[]{buffer};
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtilCore.splitNameIntoWords((String)name2)));
        if (name2.startsWith(prefix) && !prefix.isEmpty()) {
            name2 = name2.substring(prefix.length());
            result.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtilCore.splitNameIntoWords((String)name2)));
        }
        result.add(JavaNameSuggestionProvider.suggestProperlyCasedName(prefix, NameUtilCore.splitNameIntoWords((String)StringUtil.toLowerCase((String)name2))));
        return ArrayUtilRt.toStringArray(result);
    }

    private static String suggestProperlyCasedName(String prefix, String[] words) {
        StringBuilder buffer = new StringBuilder(prefix);
        for (int i = 0; i < words.length; ++i) {
            boolean prefixRequiresCapitalization;
            String word = words[i];
            boolean bl = prefixRequiresCapitalization = prefix.length() > 0 && !StringUtil.endsWithChar((CharSequence)prefix, (char)'_');
            if (i > 0 || prefixRequiresCapitalization) {
                buffer.append(StringUtil.capitalize((String)word));
                continue;
            }
            buffer.append(StringUtil.decapitalize((String)word));
        }
        return buffer.toString();
    }

    @Nullable
    private static SuggestedNameInfo suggestNamesForElement(PsiElement element, PsiElement nameSuggestionContext) {
        PsiIdentifier identifier;
        PsiVariable var = null;
        if (element instanceof PsiVariable) {
            var = (PsiVariable)element;
        } else if (element instanceof PsiIdentifier && (identifier = (PsiIdentifier)element).getParent() instanceof PsiVariable) {
            var = (PsiVariable)identifier.getParent();
        }
        if (var == null) {
            return null;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        VariableKind variableKind = codeStyleManager.getVariableKind(var);
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(variableKind, null, var.getInitializer(), var.getType());
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)nameSuggestionContext, PsiCallExpression.class, (boolean)false, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
        if (expression2 != null) {
            return new SuggestedNameInfo.Delegate(codeStyleManager.suggestVariableName((VariableKind)variableKind, null, (PsiExpression)expression2, (PsiType)var.getType()).names, nameInfo);
        }
        return nameInfo;
    }
}

