/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;

public class SafeDeleteFieldWriteReference
extends SafeDeleteReferenceUsageInfo {
    private final PsiAssignmentExpression myExpression;

    public SafeDeleteFieldWriteReference(PsiAssignmentExpression expr2, PsiField referencedElement) {
        super((PsiElement)expr2, (PsiElement)referencedElement, SafeDeleteFieldWriteReference.safeRemoveRHS(expr2));
        this.myExpression = expr2;
    }

    private static boolean safeRemoveRHS(PsiAssignmentExpression expression2) {
        PsiExpression rExpression = expression2.getRExpression();
        PsiElement parent = expression2.getParent();
        return RefactoringUtil.verifySafeCopyExpression((PsiElement)rExpression) == 0 && parent instanceof PsiExpressionStatement && ((PsiExpressionStatement)parent).getExpression() == expression2;
    }

    public void deleteElement() throws IncorrectOperationException {
        this.myExpression.getParent().delete();
    }
}

