/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaTypeConversionDescriptor;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluentIterableConversionUtil {
    private static final Logger LOG = Logger.getInstance(FluentIterableConversionUtil.class);

    @Nullable
    static TypeConversionDescriptor getToArrayDescriptor(PsiType initialType, PsiExpression expression2) {
        if (!(initialType instanceof PsiClassType)) {
            return null;
        }
        final PsiType[] parameters2 = ((PsiClassType)initialType).getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        PsiElement methodCall = expression2.getParent();
        if (!(methodCall instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiExpression[] expressions2 = ((PsiMethodCallExpression)methodCall).getArgumentList().getExpressions();
        if (expressions2.length != 1) {
            return null;
        }
        PsiExpression classTypeExpression = expressions2[0];
        PsiType targetType = classTypeExpression.getType();
        if (!(targetType instanceof PsiClassType)) {
            return null;
        }
        PsiType[] targetParameters = ((PsiClassType)targetType).getParameters();
        if (targetParameters.length != 1) {
            return null;
        }
        if (PsiTypesUtil.compareTypes((PsiType)parameters2[0], (PsiType)targetParameters[0], (boolean)false)) {
            return new TypeConversionDescriptor("$q$.toArray($type$)", null){
                final PsiType myType;
                {
                    super(stringToReplace, replaceByString);
                    this.myType = parameters2[0];
                }

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    if (evaluator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!JavaGenericsUtil.isReifiableType((PsiType)this.myType)) {
                        PsiClassType arrayType;
                        String chosenName = FluentIterableConversionUtil.chooseName(expression2, (PsiType)PsiType.INT);
                        if (this.myType instanceof PsiClassType) {
                            PsiClass resolvedClass = ((PsiClassType)this.myType).resolve();
                            if (resolvedClass == null) {
                                return expression2;
                            }
                            arrayType = resolvedClass instanceof PsiTypeParameter ? PsiType.getJavaLangObject((PsiManager)expression2.getManager(), (GlobalSearchScope)expression2.getResolveScope()) : JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createType(resolvedClass);
                        } else {
                            return null;
                        }
                        this.setReplaceByString("$q$.toArray(" + chosenName + " -> (" + this.myType.getCanonicalText(false) + "[]) new " + arrayType.getCanonicalText(false) + "[" + chosenName + "])");
                    } else {
                        this.setReplaceByString("$q$.toArray(" + this.myType.getCanonicalText(false) + "[]::new)");
                    }
                    return super.replace(expression2, evaluator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/FluentIterableConversionUtil$1", "replace"));
                }
            };
        }
        return null;
    }

    public static String chooseName(@NotNull PsiExpression context, @Nullable PsiType type2) {
        if (context == null) {
            FluentIterableConversionUtil.$$$reportNull$$$0(0);
        }
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
        String name2 = codeStyleManager.suggestUniqueVariableName(codeStyleManager.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)type2).names[0], (PsiElement)context, false);
        return nameGenerator.generateUniqueName(name2);
    }

    @Nullable
    static TypeConversionDescriptor getFilterDescriptor(@NotNull PsiMethod method, @Nullable PsiExpression context) {
        if (method == null) {
            FluentIterableConversionUtil.$$$reportNull$$$0(1);
        }
        LOG.assertTrue("filter".equals(method.getName()));
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        PsiParameter parameter2 = parameters2[0];
        PsiType type2 = parameter2.getType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass resolvedClass = ((PsiClassType)type2).resolve();
        if (resolvedClass == null) {
            return null;
        }
        if ("java.lang.Class".equals(resolvedClass.getQualifiedName())) {
            if (context == null) {
                return null;
            }
            PsiMethodCallExpression methodCall = null;
            if (context instanceof PsiMethodCallExpression) {
                methodCall = (PsiMethodCallExpression)context;
            } else if (context.getParent() instanceof PsiMethodCallExpression) {
                methodCall = (PsiMethodCallExpression)context.getParent();
            }
            if (methodCall == null) {
                return null;
            }
            PsiType filteredType = methodCall.getType();
            if (!(filteredType instanceof PsiClassType)) {
                return null;
            }
            PsiType[] filterParameters = ((PsiClassType)filteredType).getParameters();
            if (filterParameters.length != 1) {
                return null;
            }
            String filterClassName = FluentIterableConversionUtil.getFilterClassText(filterParameters[0]);
            if (filterClassName == null) {
                return null;
            }
            return new GuavaFilterInstanceOfConversionDescriptor(filterClassName);
        }
        if (GuavaLambda.PREDICATE.getClassQName().equals(resolvedClass.getQualifiedName())) {
            return new GuavaTypeConversionDescriptor("$it$.filter($p$)", "$it$.filter($p$)", context);
        }
        return null;
    }

    @Nullable
    private static String getFilterClassText(PsiType type2) {
        PsiClass boundClass;
        PsiClass filterClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (filterClass != null) {
            return filterClass.getQualifiedName();
        }
        if (type2 instanceof PsiCapturedWildcardType && (boundClass = PsiUtil.resolveClassInType((PsiType)((PsiCapturedWildcardType)type2).getUpperBound())) != null) {
            return boundClass.getQualifiedName();
        }
        return null;
    }

    static TypeConversionDescriptor createToCollectionDescriptor(@Nullable String methodName, @NotNull PsiExpression context) {
        String returnType;
        String replaceTemplate;
        String findTemplate;
        if (context == null) {
            FluentIterableConversionUtil.$$$reportNull$$$0(2);
        }
        if ("toMap".equals(methodName) || "uniqueIndex".equals(methodName)) {
            GuavaTypeConversionDescriptor descriptor = new GuavaTypeConversionDescriptor("$it$.$methodName$($f$)", "$it$.collect(java.util.stream.Collectors.toMap(java.util.function.Function.identity(), $f$))", context);
            return descriptor.withConversionType(GuavaConversionUtil.addTypeParameters("java.util.Map", context.getType(), (PsiElement)context));
        }
        if ("toList".equals(methodName)) {
            findTemplate = "$it$.toList()";
            replaceTemplate = "$it$.collect(java.util.stream.Collectors.toList())";
            returnType = "java.util.List";
        } else if ("toSet".equals(methodName)) {
            findTemplate = "$it$.toSet()";
            replaceTemplate = "$it$.collect(java.util.stream.Collectors.toSet())";
            returnType = "java.util.Set";
        } else if ("toSortedList".equals(methodName)) {
            findTemplate = "$it$.toSortedList($c$)";
            replaceTemplate = "$it$.sorted($c$).collect(java.util.stream.Collectors.toList())";
            returnType = "java.util.List";
        } else if ("toSortedSet".equals(methodName)) {
            findTemplate = "$it$.toSortedSet($c$)";
            replaceTemplate = "$it$.collect(java.util.stream.Collectors.toCollection(() -> new java.util.TreeSet<>($c$)))";
            returnType = "java.util.Set";
        } else {
            return null;
        }
        PsiType type2 = GuavaConversionUtil.addTypeParameters(returnType, context.getType(), (PsiElement)context);
        return new TypeConversionDescriptor(findTemplate, replaceTemplate).withConversionType(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/FluentIterableConversionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilterDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createToCollectionDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CopyIntoConversionDescriptor
    extends TypeConversionDescriptor {
        CopyIntoConversionDescriptor() {
            super("$it$.copyInto($c$)", null);
        }

        @Override
        public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
            String replaceTemplate;
            if (evaluator == null) {
                CopyIntoConversionDescriptor.$$$reportNull$$$0(0);
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression2.getProject());
            PsiClass javaUtilCollection = facade.findClass("java.util.Collection", expression2.getResolveScope());
            LOG.assertTrue(javaUtilCollection != null);
            PsiClassType assignableCollection = facade.getElementFactory().createType(javaUtilCollection, CopyIntoConversionDescriptor.getQualifierElementType((PsiMethodCallExpression)expression2));
            PsiType actualType = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()[0].getType();
            if (actualType == null || TypeConversionUtil.isAssignable((PsiType)assignableCollection, (PsiType)actualType)) {
                replaceTemplate = "$it$.collect(java.util.stream.Collectors.toCollection(() -> $c$))";
            } else {
                String varName = FluentIterableConversionUtil.chooseName(expression2, (PsiType)assignableCollection);
                replaceTemplate = "$it$.collect(java.util.stream.Collectors.collectingAndThen(java.util.stream.Collectors.toList(), " + varName + " -> {\n            $c$.addAll(" + varName + ");\n            return $c$;\n        }))";
            }
            this.setReplaceByString(replaceTemplate);
            return super.replace(expression2, evaluator);
        }

        @Nullable
        private static PsiType getQualifierElementType(PsiMethodCallExpression expression2) {
            PsiExpression qualifier = expression2.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            PsiType type2 = qualifier.getType();
            if (!(type2 instanceof PsiClassType)) {
                return null;
            }
            PsiType[] parameters2 = ((PsiClassType)type2).getParameters();
            if (parameters2.length > 1) {
                return null;
            }
            if (parameters2.length == 0) {
                return PsiType.getJavaLangObject((PsiManager)expression2.getManager(), (GlobalSearchScope)expression2.getResolveScope());
            }
            return parameters2[0];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/FluentIterableConversionUtil$CopyIntoConversionDescriptor", "replace"));
        }
    }

    private static class GuavaFilterInstanceOfConversionDescriptor
    extends TypeConversionDescriptor {
        GuavaFilterInstanceOfConversionDescriptor(String filterClassQName) {
            super("$it$.filter($p$)", "$it$.filter(" + filterClassQName + ".class::isInstance)." + "map" + "(" + filterClassQName + ".class::cast)");
        }
    }

    static class TransformAndConcatConversionRule
    extends GuavaTypeConversionDescriptor {
        TransformAndConcatConversionRule(PsiExpression context) {
            super("$q$.transformAndConcat($params$)", "$q$.flatMap($params$)", context);
        }

        @Override
        public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator typeEvaluator) {
            PsiAnonymousClass anonymousClass;
            PsiExpression argument;
            if (typeEvaluator == null) {
                TransformAndConcatConversionRule.$$$reportNull$$$0(0);
            }
            if ((argument = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()[0]) instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)argument).getAnonymousClass()) != null) {
                argument = GuavaConversionUtil.convertAnonymousClass((PsiNewExpression)argument, anonymousClass, typeEvaluator);
            }
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)expression2.getProject());
            if (argument != null && !(argument instanceof PsiFunctionalExpression)) {
                argument = (PsiExpression)argument.replace((PsiElement)javaPsiFacade.getElementFactory().createExpressionFromText("(" + argument.getText() + ")::apply", null));
                ParenthesesUtils.removeParentheses(argument, false);
            }
            if (argument instanceof PsiMethodReferenceExpression) {
                argument = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)argument, true, true);
            }
            if (argument instanceof PsiLambdaExpression) {
                SmartList iterableReturnValues = new SmartList();
                PsiElement body2 = ((PsiLambdaExpression)argument).getBody();
                PsiClass collection = javaPsiFacade.findClass("java.util.Collection", expression2.getResolveScope());
                if (collection == null) {
                    return expression2;
                }
                PsiClass iterable = javaPsiFacade.findClass("java.lang.Iterable", expression2.getResolveScope());
                if (iterable == null) {
                    return expression2;
                }
                if (body2 instanceof PsiCodeBlock) {
                    for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiCodeBlock)((PsiCodeBlock)body2))) {
                        PsiExpression retValue = statement.getReturnValue();
                        if (TransformAndConcatConversionRule.determineType(retValue, (List<? super Pair<PsiExpression, Boolean>>)iterableReturnValues, iterable, collection)) continue;
                        return expression2;
                    }
                } else if (!(body2 instanceof PsiExpression) || !TransformAndConcatConversionRule.determineType((PsiExpression)body2, (List<? super Pair<PsiExpression, Boolean>>)iterableReturnValues, iterable, collection)) {
                    return expression2;
                }
                for (Pair returnValueAndIsCollection : iterableReturnValues) {
                    TransformAndConcatConversionRule.convertToStream((PsiExpression)returnValueAndIsCollection.getFirst(), (Boolean)returnValueAndIsCollection.getSecond());
                }
            } else {
                return expression2;
            }
            return super.replace(expression2, typeEvaluator);
        }

        private static boolean determineType(PsiExpression retValue, List<? super Pair<PsiExpression, Boolean>> iterableReturnValues, PsiClass iterable, PsiClass collection) {
            PsiClass resolvedClass;
            if (retValue == null) {
                return false;
            }
            PsiType type2 = retValue.getType();
            if (PsiType.NULL.equals((Object)type2)) {
                return true;
            }
            if (type2 instanceof PsiCapturedWildcardType) {
                type2 = ((PsiCapturedWildcardType)type2).getUpperBound();
            }
            if (type2 instanceof PsiClassType && InheritanceUtil.isInheritorOrSelf((PsiClass)(resolvedClass = ((PsiClassType)type2).resolve()), (PsiClass)iterable, (boolean)true)) {
                boolean isCollection = InheritanceUtil.isInheritorOrSelf((PsiClass)resolvedClass, (PsiClass)collection, (boolean)true);
                iterableReturnValues.add((Pair<PsiExpression, Boolean>)Pair.create((Object)retValue, (Object)isCollection));
                return true;
            }
            return false;
        }

        private static void convertToStream(@NotNull PsiExpression returnValue, boolean isCollection) {
            PsiExpression newExpression;
            if (returnValue == null) {
                TransformAndConcatConversionRule.$$$reportNull$$$0(1);
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)returnValue.getProject());
            if (isCollection) {
                String expressionAsText = "(" + returnValue.getText() + ").stream()";
                newExpression = elementFactory.createExpressionFromText(expressionAsText, (PsiElement)returnValue);
                ParenthesesUtils.removeParentheses(newExpression, false);
            } else {
                String methodCall = "(" + returnValue.getText() + ")";
                boolean needParentheses = ParenthesesUtils.areParenthesesNeeded((PsiParenthesizedExpression)elementFactory.createExpressionFromText(methodCall, null), false);
                String expressionAsText = "java.util.stream.StreamSupport.stream(" + (needParentheses ? methodCall : methodCall.substring(1, methodCall.length() - 1)) + ".spliterator(), false)";
                newExpression = elementFactory.createExpressionFromText(expressionAsText, (PsiElement)returnValue);
            }
            returnValue.replace((PsiElement)newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeEvaluator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/FluentIterableConversionUtil$TransformAndConcatConversionRule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convertToStream";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

