/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambdaConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaPredicatesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaPredicateConversionRule
extends GuavaLambdaConversionRule {
    private static final String GUAVA_PREDICATES_UTILITY = "com.google.common.base.Predicates";

    protected GuavaPredicateConversionRule() {
        super(GuavaLambda.PREDICATE);
    }

    @Override
    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        Set<String> set = Collections.singleton(GUAVA_PREDICATES_UTILITY);
        if (set == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        TypeConversionDescriptorBase descriptor;
        if (method == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            GuavaPredicateConversionRule.$$$reportNull$$$0(2);
        }
        if (!(context instanceof PsiMethodCallExpression)) {
            return null;
        }
        if (GuavaPredicateConversionRule.isPredicates((PsiMethodCallExpression)context) && (descriptor = GuavaPredicatesUtil.tryConvertIfPredicates(method, context)) != null) {
            return descriptor;
        }
        return new TypeConversionDescriptorBase(){

            @Override
            public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                if (evaluator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (PsiExpression)expression2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(expression2.getText() + "::apply", (PsiElement)expression2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule$1", "replace"));
            }
        };
    }

    public static boolean isPredicates(PsiMethodCallExpression expression2) {
        String methodName = expression2.getMethodExpression().getReferenceName();
        if (GuavaPredicatesUtil.PREDICATES_METHOD_NAMES.contains(methodName)) {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass != null && GUAVA_PREDICATES_UTILITY.equals(aClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUtilityClasses";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaPredicateConversionRule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

