/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringConflictsUtil {
    private RefactoringConflictsUtil() {
    }

    public static void analyzeAccessibilityConflicts(@NotNull Set<? extends PsiMember> membersToMove, @NotNull PsiClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts, @Nullable String newVisibility) {
        if (membersToMove == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(1);
        }
        if (conflicts == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(2);
        }
        RefactoringConflictsUtil.analyzeAccessibilityConflicts(membersToMove, targetClass, conflicts, newVisibility, (PsiElement)targetClass, null);
    }

    public static void analyzeAccessibilityConflicts(@NotNull Set<? extends PsiMember> membersToMove, @Nullable PsiClass targetClass, @NotNull MultiMap<PsiElement, String> conflicts, @Nullable String newVisibility, @NotNull PsiElement context, @Nullable Set<? extends PsiMethod> abstractMethods) {
        if (membersToMove == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(5);
        }
        if ("EscalateVisible".equals(newVisibility)) {
            newVisibility = "public";
        }
        for (PsiMember psiMember : membersToMove) {
            RefactoringConflictsUtil.checkUsedElements(psiMember, (PsiElement)psiMember, membersToMove, abstractMethods, targetClass, context, conflicts);
            RefactoringConflictsUtil.checkAccessibilityConflicts(psiMember, newVisibility, targetClass, membersToMove, conflicts);
        }
    }

    public static void checkAccessibilityConflicts(@NotNull PsiMember member, @PsiModifier.ModifierConstant @Nullable String newVisibility, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiModifierList modifierListCopy;
        if (member == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(6);
        }
        if (membersToMove == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(7);
        }
        if (conflicts == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(8);
        }
        if ((modifierListCopy = member.getModifierList()) != null) {
            modifierListCopy = (PsiModifierList)modifierListCopy.copy();
            PsiClass containingClass = member.getContainingClass();
            if (containingClass != null && containingClass.isInterface()) {
                VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)"public");
            }
        }
        if (newVisibility != null && modifierListCopy != null) {
            try {
                VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)newVisibility);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        RefactoringConflictsUtil.checkAccessibilityConflicts(member, modifierListCopy, targetClass, membersToMove, conflicts);
    }

    public static void checkAccessibilityConflicts(@NotNull PsiMember member, @Nullable PsiModifierList modifierListCopy, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(9);
        }
        if (membersToMove == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(10);
        }
        if (conflicts == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(11);
        }
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
            RefactoringConflictsUtil.checkAccessibilityConflicts(psiReference, member, modifierListCopy, targetClass, membersToMove, conflicts);
        }
    }

    public static void checkAccessibilityConflicts(@NotNull PsiReference reference, @NotNull PsiMember member, @Nullable PsiModifierList modifierListCopy, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (reference == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(12);
        }
        if (member == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(13);
        }
        if (membersToMove == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(14);
        }
        if (conflicts == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(15);
        }
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)member.getProject());
        PsiElement ref = reference.getElement();
        if (!RefactoringHierarchyUtil.willBeInTargetClass(ref, membersToMove, targetClass, false)) {
            if (targetClass != null && !manager.getResolveHelper().isAccessible((PsiMember)targetClass, targetClass.getModifierList(), ref, null, null)) {
                String message2 = JavaRefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)targetClass), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(ref), (boolean)true)});
                message2 = CommonRefactoringUtil.capitalize((String)message2);
                conflicts.putValue((Object)targetClass, (Object)message2);
            } else if (!manager.getResolveHelper().isAccessible(member, modifierListCopy, ref, targetClass, null)) {
                String message3 = JavaRefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true), VisibilityUtil.toPresentableText((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierListCopy)), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(ref), (boolean)true)});
                message3 = CommonRefactoringUtil.capitalize((String)message3);
                conflicts.putValue((Object)member, (Object)message3);
            }
        }
    }

    public static void checkUsedElements(PsiMember member, PsiElement scope, @NotNull Set<? extends PsiMember> membersToMove, @Nullable Set<? extends PsiMethod> abstractMethods, @Nullable PsiClass targetClass, @NotNull PsiElement context, MultiMap<PsiElement, String> conflicts) {
        if (membersToMove == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(17);
        }
        RefactoringConflictsUtil.checkUsedElements(member, scope, membersToMove, abstractMethods, targetClass, null, context, conflicts);
    }

    public static void checkUsedElements(PsiMember member, PsiElement scope, @NotNull Set<? extends PsiMember> membersToMove, @Nullable Set<? extends PsiMethod> abstractMethods, @Nullable PsiClass targetClass, PsiClass accessClass, @NotNull PsiElement context, MultiMap<PsiElement, String> conflicts) {
        PsiElement refElement;
        PsiReferenceExpression refExpr;
        if (membersToMove == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(19);
        }
        HashSet<? extends PsiMember> moving = new HashSet<PsiMember>(membersToMove);
        if (abstractMethods != null) {
            moving.addAll(abstractMethods);
        }
        if (scope instanceof PsiReferenceExpression) {
            refExpr = (PsiReferenceExpression)scope;
            refElement = refExpr.resolve();
            if (refElement instanceof PsiMember) {
                PsiClass qualifierAccessClass;
                PsiExpression qualifier = refExpr.getQualifierExpression();
                Object object = qualifier != null && !(qualifier instanceof PsiSuperExpression) ? PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement() : (qualifierAccessClass = accessClass != null && PsiTreeUtil.isAncestor((PsiElement)((PsiMember)refElement).getContainingClass(), (PsiElement)accessClass, (boolean)true) ? null : accessClass);
                if (!(RefactoringHierarchyUtil.willBeInTargetClass(refElement, moving, targetClass, false) || qualifierAccessClass != null && RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)qualifierAccessClass, moving, targetClass, false))) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement, context, qualifierAccessClass, member, conflicts);
                }
            }
        } else if (scope instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)scope;
            PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
            if (anonymousClass != null) {
                if (!RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)anonymousClass, moving, targetClass, false)) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)anonymousClass, context, (PsiClass)anonymousClass, member, conflicts);
                }
            } else {
                PsiMethod refElement2 = newExpression.resolveConstructor();
                if (refElement2 != null && !RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refElement2, moving, targetClass, false)) {
                    RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement2, context, accessClass, member, conflicts);
                }
            }
        } else if (scope instanceof PsiJavaCodeReferenceElement && (refElement = (refExpr = (PsiJavaCodeReferenceElement)scope).resolve()) instanceof PsiMember && !RefactoringHierarchyUtil.willBeInTargetClass(refElement, moving, targetClass, false)) {
            RefactoringConflictsUtil.checkAccessibility((PsiMember)refElement, context, accessClass, member, conflicts);
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiWhiteSpace || child instanceof PsiComment) continue;
            RefactoringConflictsUtil.checkUsedElements(member, child, membersToMove, abstractMethods, targetClass, child instanceof PsiClass ? (PsiClass)child : accessClass, context, conflicts);
        }
    }

    public static void checkAccessibility(PsiMember refMember, @NotNull PsiElement newContext, @Nullable PsiClass accessClass, PsiMember member, MultiMap<PsiElement, String> conflicts) {
        PsiField fieldInSubClass;
        PsiResolveHelper helper;
        if (newContext == null) {
            RefactoringConflictsUtil.$$$reportNull$$$0(20);
        }
        if (!(helper = JavaPsiFacade.getInstance((Project)newContext.getProject()).getResolveHelper()).isAccessible(refMember, refMember.getModifierList(), newContext, accessClass, newContext)) {
            String message2 = JavaRefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)refMember, (boolean)true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)refMember), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            message2 = CommonRefactoringUtil.capitalize((String)message2);
            conflicts.putValue((Object)refMember, (Object)message2);
        } else if (newContext instanceof PsiClass && refMember instanceof PsiField && refMember.getContainingClass() == member.getContainingClass() && (fieldInSubClass = ((PsiClass)newContext).findFieldByName(refMember.getName(), false)) != null && !refMember.hasModifierProperty("static") && fieldInSubClass != refMember && !member.hasModifierProperty("static")) {
            conflicts.putValue((Object)refMember, (Object)CommonRefactoringUtil.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)fieldInSubClass, (boolean)true) + " would hide " + RefactoringUIUtil.getDescription((PsiElement)refMember, (boolean)true) + " which is used by moved " + RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false))));
        }
    }

    public static void analyzeModuleConflicts(Project project, Collection<? extends PsiElement> scopes, UsageInfo[] usages, PsiElement target, MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)target);
        if (vFile == null) {
            return;
        }
        RefactoringConflictsUtil.analyzeModuleConflicts(project, scopes, usages, vFile, conflicts);
    }

    public static void analyzeModuleConflicts(final Project project, final Collection<? extends PsiElement> scopes, UsageInfo[] usages, VirtualFile vFile, final MultiMap<PsiElement, String> conflicts) {
        if (scopes == null) {
            return;
        }
        for (PsiElement psiElement : scopes) {
            if (!(psiElement instanceof PsiPackage)) continue;
            return;
        }
        final Module targetModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (targetModule == null) {
            return;
        }
        final GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)targetModule);
        final HashSet reported = new HashSet();
        final Consumer<PsiJavaCodeReferenceElement> processor = new Consumer<PsiJavaCodeReferenceElement>(){

            @Override
            public void accept(PsiJavaCodeReferenceElement reference) {
                PsiElement resolved = reference.resolve();
                if (!(resolved == null || reported.contains(resolved) || CommonRefactoringUtil.isAncestor((PsiElement)resolved, (Collection)scopes) || resolved instanceof LightElement || !resolved.isPhysical() || this.haveElementInScope(resolved))) {
                    if (resolved instanceof PsiMethod) {
                        for (PsiMethod superMethod : ((PsiMethod)resolved).findDeepestSuperMethods()) {
                            if (!this.haveElementInScope((PsiElement)superMethod)) continue;
                            return;
                        }
                    }
                    String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)reference), (boolean)true);
                    String message2 = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.in.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)resolved, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)targetModule.getName())});
                    conflicts.putValue((Object)reference, (Object)CommonRefactoringUtil.capitalize((String)message2));
                    reported.add(resolved);
                }
            }

            private boolean haveElementInScope(PsiElement resolved) {
                if (PsiSearchScopeUtil.isInScope((GlobalSearchScope)globalSearchScope, (PsiElement)resolved)) {
                    return true;
                }
                if (!resolved.getManager().isInProject(resolved)) {
                    PsiClass classFromTarget;
                    String fqn;
                    PsiClass containingClass;
                    if (resolved instanceof PsiMember && (containingClass = ((PsiMember)resolved).getContainingClass()) != null && (fqn = containingClass.getQualifiedName()) != null && (classFromTarget = JavaPsiFacade.getInstance((Project)project).findClass(fqn, globalSearchScope)) != null) {
                        if (resolved instanceof PsiMethod) {
                            return classFromTarget.findMethodsBySignature((PsiMethod)resolved, true).length > 0;
                        }
                        if (resolved instanceof PsiField) {
                            return classFromTarget.findFieldByName(((PsiField)resolved).getName(), false) != null;
                        }
                        if (resolved instanceof PsiClass) {
                            return classFromTarget.findInnerClassByName(((PsiClass)resolved).getName(), false) != null;
                        }
                    }
                    if (resolved instanceof PsiClass) {
                        String fqn2 = ((PsiClass)resolved).getQualifiedName();
                        return fqn2 != null && JavaPsiFacade.getInstance((Project)project).findClass(fqn2, globalSearchScope) != null;
                    }
                }
                return false;
            }
        };
        for (PsiElement psiElement : scopes) {
            JavaRecursiveElementWalkingVisitor visitor2;
            if (psiElement instanceof PsiCompiledElement) {
                JavaRecursiveElementVisitor visitor22 = new JavaRecursiveElementVisitor(){

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        super.visitReferenceElement(reference);
                        processor.accept(reference);
                    }
                };
            } else {
                visitor2 = new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        super.visitReferenceElement(reference);
                        processor.accept(reference);
                    }
                };
            }
            ProgressManager.progress((String)JavaRefactoringBundle.message((String)"processing.progress.text", (Object[])new Object[]{SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiElement)}));
            psiElement.accept((PsiElementVisitor)visitor2);
        }
        boolean isInTestSources = ModuleRootManager.getInstance((Module)targetModule).getFileIndex().isInTestSourceContent(vFile);
        block2: for (UsageInfo usage : usages) {
            String message2;
            Module module;
            PsiElement element = usage.getElement();
            if (element == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class, (boolean)false) != null) continue;
            for (PsiElement psiElement : scopes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
                continue block2;
            }
            GlobalSearchScope resolveScope1 = element.getResolveScope();
            if (resolveScope1.isSearchInModuleContent(targetModule, isInTestSources)) continue;
            PsiFile psiFile = element.getContainingFile();
            Object container = psiFile instanceof PsiJavaFile ? ConflictsUtil.getContainer(element) : psiFile;
            String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
            VirtualFile usageVFile = psiFile.getVirtualFile();
            if (usageVFile == null || (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(usageVFile)) == null) continue;
            PsiElement referencedElement = usage instanceof MoveRenameUsageInfo ? ((MoveRenameUsageInfo)usage).getReferencedElement() : usage.getElement();
            assert (referencedElement != null) : usage;
            if (module == targetModule && isInTestSources) {
                String message3 = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.production.of.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            } else {
                message2 = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            }
            conflicts.putValue((Object)element, (Object)CommonRefactoringUtil.capitalize((String)message2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/RefactoringConflictsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeAccessibilityConflicts";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAccessibilityConflicts";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUsedElements";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAccessibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

