/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;

public class RefactoringMessageUtil {
    public static String getIncorrectIdentifierMessage(String identifierName) {
        return JavaRefactoringBundle.message((String)"0.is.not.a.legal.java.identifier", (Object[])new Object[]{identifierName});
    }

    public static String checkCanCreateClass(PsiDirectory destinationDirectory, String className2) {
        PsiClass[] classes2 = JavaDirectoryService.getInstance().getClasses(destinationDirectory);
        VirtualFile file = destinationDirectory.getVirtualFile();
        for (PsiClass aClass : classes2) {
            if (!className2.equals(aClass.getName())) continue;
            return JavaRefactoringBundle.message((String)"directory.0.already.contains.1.named.2", (Object[])new Object[]{file.getPresentableUrl(), UsageViewUtil.getType((PsiElement)aClass), className2});
        }
        String fileName = className2 + ".java";
        return RefactoringMessageUtil.checkCanCreateFile(destinationDirectory, fileName);
    }

    public static String checkCanCreateFile(PsiDirectory destinationDirectory, String fileName) {
        VirtualFile file = destinationDirectory.getVirtualFile();
        VirtualFile child = file.findChild(fileName);
        if (child != null) {
            return JavaRefactoringBundle.message((String)"directory.0.already.contains.a.file.named.1", (Object[])new Object[]{file.getPresentableUrl(), fileName});
        }
        return null;
    }

    public static String getGetterSetterMessage(String newName, String action, PsiMethod getter, PsiMethod setter) {
        String text2 = getter != null && setter != null ? JavaRefactoringBundle.message((String)"getter.and.setter.methods.found.for.the.field.0", (Object[])new Object[]{newName, action}) : (getter != null ? JavaRefactoringBundle.message((String)"getter.method.found.for.the.field.0", (Object[])new Object[]{newName, action}) : JavaRefactoringBundle.message((String)"setter.method.found.for.the.field.0", (Object[])new Object[]{newName, action}));
        return text2;
    }

    public static void showNotSupportedForJspClassesError(Project project, Editor editor, String refactoringName, String helpId) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"refactoring.is.not.supported.for.jsp.classes", (Object[])new Object[0]));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)refactoringName, (String)helpId);
    }
}

