/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.ConstantMatchProvider;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesMatchProvider;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodDuplicatesHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    @Deprecated
    public static final String REFACTORING_NAME = "Replace Code Duplicates";
    private static final Logger LOG = Logger.getInstance(MethodDuplicatesHandler.class);

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiElement element;
        if (editor == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(2);
        }
        return MethodDuplicatesHandler.getCannotRefactorMessage((PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(editor.getCaretModel().getOffset())), PsiMember.class)) == null;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        int offset;
        PsiElement element;
        PsiMember member;
        String cannotRefactorMessage;
        if (project == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(3);
        }
        if ((cannotRefactorMessage = MethodDuplicatesHandler.getCannotRefactorMessage(member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(offset = editor.getCaretModel().getOffset())), PsiMember.class))) != null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)cannotRefactorMessage);
            MethodDuplicatesHandler.showErrorMessage(message2, project, editor);
            return;
        }
        AnalysisScope scope = new AnalysisScope(file);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(JavaRefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.title", (Object[])new Object[]{MethodDuplicatesHandler.getRefactoringName()}), JavaRefactoringBundle.message((String)"replace.method.duplicates.scope.chooser.message", (Object[])new Object[0]), project, BaseAnalysisActionDialog.standardItems((Project)project, (AnalysisScope)scope, (Module)module, (PsiElement)element), AnalysisUIOptions.getInstance((Project)project), false);
        if (dlg.showAndGet()) {
            final AnalysisScope selectedScope = dlg.getScope(AnalysisUIOptions.getInstance((Project)project), scope, project, module);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaRefactoringBundle.message((String)"locate.duplicates.action.name", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    MethodDuplicatesHandler.invokeOnScope(project, member, selectedScope);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$1", "run"));
                }
            });
        }
    }

    @Nullable
    private static String getCannotRefactorMessage(PsiMember member) {
        if (member == null) {
            return JavaRefactoringBundle.message((String)"locate.caret.inside.a.method", (Object[])new Object[0]);
        }
        if (member instanceof PsiMethod) {
            if (((PsiMethod)member).isConstructor()) {
                return JavaRefactoringBundle.message((String)"replace.with.method.call.does.not.work.for.constructors", (Object[])new Object[0]);
            }
            PsiCodeBlock body2 = ((PsiMethod)member).getBody();
            if (body2 == null) {
                return JavaRefactoringBundle.message((String)"method.does.not.have.a.body", (Object[])new Object[]{member.getName()});
            }
            PsiStatement[] statements = body2.getStatements();
            if (statements.length == 0) {
                return JavaRefactoringBundle.message((String)"method.has.an.empty.body", (Object[])new Object[]{member.getName()});
            }
        } else if (member instanceof PsiField) {
            PsiField field = (PsiField)member;
            if (field.getInitializer() == null) {
                return "Field " + member.getName() + " doesn't have initializer";
            }
            PsiClass containingClass = field.getContainingClass();
            if (!field.hasModifierProperty("final") || !field.hasModifierProperty("static") || containingClass == null || containingClass.getQualifiedName() == null) {
                return "Replace Duplicates works with constants only";
            }
        } else {
            return "Caret should be inside method or constant";
        }
        return null;
    }

    public static void invokeOnScope(Project project, PsiMember member, AnalysisScope scope) {
        MethodDuplicatesHandler.invokeOnScope(project, Collections.singleton(member), scope, false);
    }

    public static void invokeOnScope(final Project project, final Set<? extends PsiMember> members, AnalysisScope scope, boolean silent) {
        final HashMap<PsiMember, List<Match>> duplicates = new HashMap<PsiMember, List<Match>>();
        final int fileCount = scope.getFileCount();
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(false);
        }
        final HashMap memberWithModulesMap = new HashMap();
        for (PsiMember psiMember : members) {
            Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)member));
            if (module == null) continue;
            HashSet dependencies = new HashSet();
            ApplicationManager.getApplication().runReadAction(() -> ModuleUtilCore.collectModulesDependsOn((Module)module, (Set)dependencies));
            memberWithModulesMap.put(psiMember, dependencies);
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private int myFileCount;

            public void visitFile(@NotNull PsiFile file) {
                Module targetModule;
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (progressIndicator != null) {
                    if (progressIndicator.isCanceled()) {
                        return;
                    }
                    progressIndicator.setFraction((double)this.myFileCount++ / (double)fileCount);
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile != null) {
                        progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    }
                }
                if ((targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
                    return;
                }
                for (Map.Entry entry : memberWithModulesMap.entrySet()) {
                    Set dependencies = (Set)entry.getValue();
                    if (dependencies == null || !dependencies.contains(targetModule)) continue;
                    PsiMember method = (PsiMember)entry.getKey();
                    List<Match> matchList = MethodDuplicatesHandler.hasDuplicates((PsiElement)file, method);
                    Iterator<Match> iterator = matchList.iterator();
                    while (iterator.hasNext()) {
                        Match match = iterator.next();
                        PsiElement matchStart = match.getMatchStart();
                        PsiElement matchEnd = match.getMatchEnd();
                        for (PsiMember psiMember : members) {
                            if (!PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)matchStart, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)matchEnd, (boolean)false)) continue;
                            iterator.remove();
                            break;
                        }
                        if (!(method instanceof PsiMethod) || ((PsiMethod)method).findDeepestSuperMethods().length <= 0 || !MethodDuplicatesMatchProvider.isEssentialStaticContextAbsent(match, (PsiMethod)method)) continue;
                        iterator.remove();
                    }
                    if (matchList.isEmpty()) continue;
                    ArrayList<Match> matches = (ArrayList<Match>)duplicates.get(method);
                    if (matches == null) {
                        matches = new ArrayList<Match>();
                        duplicates.put(method, matches);
                    }
                    matches.addAll(matchList);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler$2", "visitFile"));
            }
        });
        if (duplicates.isEmpty()) {
            if (!silent) {
                Runnable nothingFoundRunnable = () -> {
                    String message2 = JavaRefactoringBundle.message((String)"idea.has.not.found.any.code.that.can.be.replaced.with.method.call", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
                    Messages.showInfoMessage((Project)project, (String)message2, (String)MethodDuplicatesHandler.getRefactoringName());
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    nothingFoundRunnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(nothingFoundRunnable, project.getDisposed());
                }
            }
        } else {
            MethodDuplicatesHandler.replaceDuplicate(project, duplicates, members);
        }
    }

    public static void replaceDuplicate(Project project, Map<PsiMember, List<Match>> duplicates, Set<? extends PsiMember> methods) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null && progressIndicator.isCanceled()) {
            return;
        }
        Runnable replaceRunnable = () -> {
            LocalHistoryAction a = LocalHistory.getInstance().startAction(MethodDuplicatesHandler.getRefactoringName());
            try {
                for (PsiMember member : methods) {
                    List matches = (List)duplicates.get(member);
                    if (matches == null) continue;
                    int duplicatesNo = matches.size();
                    WindowManager.getInstance().getStatusBar(project).setInfo(MethodDuplicatesHandler.getStatusMessage(duplicatesNo));
                    CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> {
                        MatchProvider matchProvider = member instanceof PsiMethod ? new MethodDuplicatesMatchProvider((PsiMethod)member, matches) : new ConstantMatchProvider(member, project, matches);
                        DuplicatesImpl.invoke(project, matchProvider, true);
                    }), MethodDuplicatesHandler.getRefactoringName(), (Object)MethodDuplicatesHandler.getRefactoringName());
                    WindowManager.getInstance().getStatusBar(project).setInfo("");
                }
            }
            finally {
                a.finish();
            }
        };
        ApplicationManager.getApplication().invokeLater(replaceRunnable, project.getDisposed());
    }

    public static List<Match> hasDuplicates(PsiElement file, PsiMember member) {
        DuplicatesFinder duplicatesFinder = MethodDuplicatesHandler.createDuplicatesFinder(member);
        if (duplicatesFinder == null) {
            return Collections.emptyList();
        }
        return duplicatesFinder.findDuplicates(file);
    }

    @Nullable
    public static DuplicatesFinder createDuplicatesFinder(PsiMember member) {
        PsiElement[] pattern;
        VariableReturnValue matchedReturnValue = null;
        if (member instanceof PsiMethod) {
            PsiCodeBlock body2 = ((PsiMethod)member).getBody();
            LOG.assertTrue(body2 != null);
            PsiStatement[] statements = body2.getStatements();
            pattern = statements;
            matchedReturnValue = null;
            if (statements.length != 1 || !(statements[0] instanceof PsiReturnStatement)) {
                PsiElement resolved;
                PsiExpression returnValue;
                PsiStatement lastStatement;
                PsiStatement psiStatement = lastStatement = statements.length > 0 ? statements[statements.length - 1] : null;
                if (lastStatement instanceof PsiReturnStatement && (returnValue = ((PsiReturnStatement)lastStatement).getReturnValue()) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiVariable) {
                    pattern = new PsiElement[statements.length - 1];
                    System.arraycopy(statements, 0, pattern, 0, statements.length - 1);
                    matchedReturnValue = new VariableReturnValue((PsiVariable)resolved);
                }
            } else {
                PsiExpression returnValue = ((PsiReturnStatement)statements[0]).getReturnValue();
                if (returnValue != null) {
                    pattern = new PsiElement[]{returnValue};
                }
            }
        } else {
            pattern = new PsiElement[]{((PsiField)member).getInitializer()};
        }
        if (pattern.length == 0) {
            return null;
        }
        ArrayList inputVariables = member instanceof PsiMethod ? Arrays.asList(((PsiMethod)member).getParameterList().getParameters()) : new ArrayList();
        return new DuplicatesFinder(pattern, new InputVariables(inputVariables, member.getProject(), new LocalSearchScope(pattern), false, Collections.emptySet()), matchedReturnValue, new ArrayList());
    }

    static String getStatusMessage(int duplicatesNo) {
        return JavaRefactoringBundle.message((String)"method.duplicates.found.message", (Object[])new Object[]{duplicatesNo});
    }

    private static void showErrorMessage(String message2, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)MethodDuplicatesHandler.getRefactoringName(), (String)"refactoring.replaceMethodCodeDuplicates");
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            MethodDuplicatesHandler.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"replace.method.code.duplicates.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/duplicates/MethodDuplicatesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

