/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.util;

import com.intellij.packaging.artifacts.Artifact;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;

public abstract class ArtifactDeploymentRuntimeProviderBase
implements CloudDeploymentRuntimeProvider {
    public CloudDeploymentRuntime createDeploymentRuntime(DeploymentSource source, CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentTask<? extends CloudDeploymentNameConfiguration> deploymentTask, DeploymentLogManager logManager) throws ServerRuntimeException {
        if (!(source instanceof ArtifactDeploymentSource)) {
            return null;
        }
        ArtifactDeploymentSource artifactSource = (ArtifactDeploymentSource)source;
        Artifact artifact = artifactSource.getArtifact();
        if (artifact == null) {
            throw new ServerRuntimeException("Artifact not found " + artifactSource.getArtifactPointer().getArtifactName());
        }
        String artifactPath = artifact.getOutputFilePath();
        if (artifactPath == null) {
            throw new ServerRuntimeException("Artifact output not found");
        }
        return this.doCreateDeploymentRuntime(artifactSource, new File(artifactPath), serverRuntime, deploymentTask, logManager);
    }

    protected abstract CloudDeploymentRuntime doCreateDeploymentRuntime(ArtifactDeploymentSource var1, File var2, CloudMultiSourceServerRuntimeInstance var3, DeploymentTask<? extends CloudDeploymentNameConfiguration> var4, DeploymentLogManager var5) throws ServerRuntimeException;
}

