/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LiteralExpressionTokenizer
extends EscapeSequenceTokenizer<PsiLiteralExpression> {
    public void tokenize(@NotNull PsiLiteralExpression element, TokenConsumer consumer) {
        PsiLiteralExpressionImpl literalExpression;
        IElementType literalElementType;
        String text2;
        if (element == null) {
            LiteralExpressionTokenizer.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(text2 = (literalElementType = (literalExpression = (PsiLiteralExpressionImpl)element).getLiteralElementType()) == JavaTokenType.STRING_LITERAL ? literalExpression.getInnerText() : (literalElementType == JavaTokenType.TEXT_BLOCK_LITERAL ? literalExpression.getText() : null))) || text2.length() <= 2) {
            return;
        }
        if (InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)literalExpression)) {
            return;
        }
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
        if (listOwner != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)listOwner, (String)"org.jetbrains.annotations.NonNls", (int)2)) {
            PsiElement targetElement = LiteralExpressionTokenizer.getCompleteStringValueExpression((PsiExpression)element);
            if (listOwner instanceof PsiMethod ? Arrays.stream(PsiUtil.findReturnStatements((PsiMethod)((PsiMethod)listOwner))).map(s -> s.getReturnValue()).anyMatch(e -> e == targetElement) : listOwner instanceof PsiVariable && ((PsiVariable)listOwner).getInitializer() == targetElement) {
                return;
            }
        }
        if (!text2.contains("\\")) {
            consumer.consumeToken((PsiElement)element, (Splitter)PlainTextSplitter.getInstance());
        } else {
            LiteralExpressionTokenizer.processTextWithEscapeSequences(element, text2, consumer);
        }
    }

    public static void processTextWithEscapeSequences(PsiLiteralExpression element, String text2, TokenConsumer consumer) {
        StringBuilder unescapedText = new StringBuilder();
        int[] offsets = new int[text2.length() + 1];
        PsiLiteralExpressionImpl.parseStringCharacters(text2, unescapedText, offsets);
        LiteralExpressionTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)1);
    }

    public static PsiElement getCompleteStringValueExpression(PsiExpression expression2) {
        return ExpressionUtils.isStringConcatenationOperand(expression2) ? expression2.getParent() : expression2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/LiteralExpressionTokenizer", "tokenize"));
    }
}

