/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi.parsing;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spi.parsing.SPIElementTypes;
import com.intellij.spi.parsing.SPILexer;
import com.intellij.spi.parsing.SPITokenType;
import com.intellij.spi.psi.SPIClassProviderReferenceElement;
import com.intellij.spi.psi.SPIClassProvidersElementList;
import com.intellij.spi.psi.SPIFile;
import com.intellij.spi.psi.SPIPackageOrClassReferenceElement;
import org.jetbrains.annotations.NotNull;

public class SPIParserDefinition
implements ParserDefinition {
    public static final IFileElementType SPI_FILE_ELEMENT_TYPE = new IFileElementType((Language)SPILanguage.INSTANCE);
    private static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final Logger LOG = Logger.getInstance(SPIParserDefinition.class);

    @NotNull
    public Lexer createLexer(Project project) {
        return new SPILexer();
    }

    public PsiParser createParser(Project project) {
        return new PsiParser(){

            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder) {
                PsiBuilder.Marker rootMarker = builder.mark();
                PsiBuilder.Marker propertiesList = builder.mark();
                while (!builder.eof()) {
                    SPIParserDefinition.parseProvider(builder);
                }
                propertiesList.done(SPIElementTypes.PROVIDERS_LIST);
                rootMarker.done(root);
                ASTNode aSTNode = builder.getTreeBuilt();
                if (aSTNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                return aSTNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/parsing/SPIParserDefinition$1", "parse"));
            }
        };
    }

    public IFileElementType getFileNodeType() {
        return SPI_FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACES;
        if (tokenSet == null) {
            SPIParserDefinition.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.END_OF_LINE_COMMENT});
        if (tokenSet == null) {
            SPIParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            SPIParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType elementType = node.getElementType();
        if (elementType == SPIElementTypes.PROVIDERS_LIST) {
            return new SPIClassProvidersElementList(node);
        }
        if (elementType == SPIElementTypes.PROVIDER) {
            return new SPIClassProviderReferenceElement(node);
        }
        if (elementType == SPIElementTypes.PACK) {
            return new SPIPackageOrClassReferenceElement(node);
        }
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            SPIParserDefinition.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new SPIFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public static void parseProvider(PsiBuilder builder) {
        if (builder.getTokenType() == SPITokenType.IDENTIFIER) {
            PsiBuilder.Marker prop = builder.mark();
            SPIParserDefinition.parseProviderChar(builder, builder.mark());
            prop.done(SPIElementTypes.PROVIDER);
        } else {
            builder.advanceLexer();
            builder.error(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]));
        }
    }

    private static void parseProviderChar(PsiBuilder builder, PsiBuilder.Marker pack) {
        builder.advanceLexer();
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.DOT || tokenType == SPITokenType.DOLLAR) {
            pack.done(SPIElementTypes.PACK);
            builder.advanceLexer();
            IElementType initialTokenType = builder.getTokenType();
            if (initialTokenType == null) {
                return;
            }
            SPIParserDefinition.parseProviderChar(builder, pack.precede());
        } else {
            pack.drop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spi/parsing/SPIParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

