/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.xml.CanonicalPsiTypeConverterImpl;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JvmPsiTypeConverter;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmPsiTypeConverterImpl
extends JvmPsiTypeConverter
implements CustomReferenceConverter<PsiType> {
    private static final BidirectionalMap<PsiType, Character> ourPrimitiveTypes = new BidirectionalMap();
    private static final JavaClassReferenceProvider JVM_REFERENCE_PROVIDER = new JavaClassReferenceProvider();
    private static final JavaClassReferenceProvider REFERENCE_PROVIDER = new JavaClassReferenceProvider();
    private static final CanonicalPsiTypeConverterImpl CANONICAL_PSI_TYPE_CONVERTER = new CanonicalPsiTypeConverterImpl();

    public PsiType fromString(String s, ConvertContext context) {
        return JvmPsiTypeConverterImpl.convertFromString(s, context);
    }

    @Nullable
    public static PsiType convertFromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("[")) {
            int arrayDimensions = JvmPsiTypeConverterImpl.getArrayDimensions(s);
            if (arrayDimensions >= s.length()) {
                return null;
            }
            char c = s.charAt(arrayDimensions);
            if (c == 'L') {
                if (!s.endsWith(";")) {
                    return null;
                }
                PsiClass aClass = DomJavaUtil.findClass((String)s.substring(arrayDimensions + 1, s.length() - 1), (PsiFile)context.getFile(), (Module)context.getModule(), null);
                return aClass == null ? null : JvmPsiTypeConverterImpl.makeArray(arrayDimensions, (PsiType)JvmPsiTypeConverterImpl.createType(aClass));
            }
            if (s.length() == arrayDimensions + 1) {
                List list = ourPrimitiveTypes.getKeysByValue((Object)Character.valueOf(c));
                return list == null || list.isEmpty() ? null : JvmPsiTypeConverterImpl.makeArray(arrayDimensions, (PsiType)list.get(0));
            }
            return null;
        }
        if (Arrays.binarySearch(CanonicalPsiTypeConverterImpl.PRIMITIVES, s) >= 0) {
            return JavaPsiFacade.getElementFactory((Project)context.getProject()).createPrimitiveType(s);
        }
        PsiClass aClass1 = DomJavaUtil.findClass((String)s, (PsiFile)context.getFile(), (Module)context.getModule(), (GlobalSearchScope)context.getSearchScope());
        return aClass1 == null ? null : JvmPsiTypeConverterImpl.createType(aClass1);
    }

    private static int getArrayDimensions(String s) {
        int arrayDimensions;
        for (arrayDimensions = 0; arrayDimensions < s.length() && s.charAt(arrayDimensions) == '['; ++arrayDimensions) {
        }
        return arrayDimensions;
    }

    private static PsiClassType createType(PsiClass aClass) {
        return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
    }

    private static PsiType makeArray(int dimensions, PsiType type2) {
        return dimensions == 0 ? type2 : JvmPsiTypeConverterImpl.makeArray(dimensions - 1, (PsiType)new PsiArrayType(type2));
    }

    public String toString(PsiType psiType, ConvertContext context) {
        return JvmPsiTypeConverterImpl.convertToString(psiType);
    }

    @Nullable
    public static String convertToString(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return '[' + JvmPsiTypeConverterImpl.toStringArray(((PsiArrayType)psiType).getComponentType());
        }
        if (psiType instanceof PsiClassType) {
            return psiType.getCanonicalText();
        }
        return null;
    }

    @NonNls
    @Nullable
    private static String toStringArray(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return '[' + JvmPsiTypeConverterImpl.toStringArray(((PsiArrayType)psiType).getComponentType());
        }
        if (psiType instanceof PsiPrimitiveType) {
            return String.valueOf(ourPrimitiveTypes.get((Object)psiType));
        }
        if (psiType instanceof PsiClassType) {
            return "L" + psiType.getCanonicalText() + ";";
        }
        return null;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiType> value2, PsiElement element, ConvertContext context) {
        PsiReference[] references;
        PsiType psiType = (PsiType)value2.getValue();
        String s = value2.getStringValue();
        assert (s != null);
        int dimensions = JvmPsiTypeConverterImpl.getArrayDimensions(s);
        if (dimensions > 0) {
            if (s.charAt(dimensions) == 'L' && s.endsWith(";")) {
                PsiReference[] psiReferenceArray = JVM_REFERENCE_PROVIDER.getReferencesByString(s.substring(dimensions + 1), element, element.getText().indexOf(s) + dimensions + 1);
                if (psiReferenceArray == null) {
                    JvmPsiTypeConverterImpl.$$$reportNull$$$0(0);
                }
                return psiReferenceArray;
            }
            if (psiType != null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    JvmPsiTypeConverterImpl.$$$reportNull$$$0(1);
                }
                return PsiReference.EMPTY_ARRAY;
            }
        }
        PsiReference[] psiReferenceArray = (references = REFERENCE_PROVIDER.getReferencesByElement(element)).length == 1 ? CANONICAL_PSI_TYPE_CONVERTER.createReferences(value2, element, context) : references;
        if (psiReferenceArray == null) {
            JvmPsiTypeConverterImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    static {
        JVM_REFERENCE_PROVIDER.setOption(JavaClassReferenceProvider.JVM_FORMAT, Boolean.TRUE);
        JVM_REFERENCE_PROVIDER.setSoft(true);
        REFERENCE_PROVIDER.setSoft(true);
        ourPrimitiveTypes.put((Object)PsiType.BYTE, (Object)Character.valueOf('B'));
        ourPrimitiveTypes.put((Object)PsiType.CHAR, (Object)Character.valueOf('C'));
        ourPrimitiveTypes.put((Object)PsiType.DOUBLE, (Object)Character.valueOf('D'));
        ourPrimitiveTypes.put((Object)PsiType.FLOAT, (Object)Character.valueOf('F'));
        ourPrimitiveTypes.put((Object)PsiType.INT, (Object)Character.valueOf('I'));
        ourPrimitiveTypes.put((Object)PsiType.LONG, (Object)Character.valueOf('L'));
        ourPrimitiveTypes.put((Object)PsiType.SHORT, (Object)Character.valueOf('S'));
        ourPrimitiveTypes.put((Object)PsiType.BOOLEAN, (Object)Character.valueOf('Z'));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/JvmPsiTypeConverterImpl", "createReferences"));
    }
}

