/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassArrayConverterImpl
extends ClassArrayConverter {
    private static final JavaClassReferenceProvider REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s != null) {
            int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
            ArrayList list = new ArrayList();
            int pos = -1;
            while (true) {
                if (pos + 1 < s.length() && Character.isWhitespace(s.charAt(pos + 1))) {
                    ++pos;
                    continue;
                }
                int nextPos = s.indexOf(44, pos + 1);
                if (nextPos == -1) break;
                ClassArrayConverterImpl.createReference(element, s.substring(pos + 1, nextPos), pos + 1 + offset, list);
                pos = nextPos;
            }
            ClassArrayConverterImpl.createReference(element, s.substring(pos + 1), pos + 1 + offset, list);
            PsiReference[] psiReferenceArray = list.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                ClassArrayConverterImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            ClassArrayConverterImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static void createReference(PsiElement element, String s, int offset, List<? super PsiReference> list) {
        PsiReference[] references = REFERENCE_PROVIDER.getReferencesByString(s, element, offset);
        list.addAll(Arrays.asList(references));
    }

    static {
        REFERENCE_PROVIDER.setSoft(true);
        REFERENCE_PROVIDER.setAllowEmpty(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/converters/ClassArrayConverterImpl", "createReferences"));
    }
}

