/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InstanceVariableOfConcreteClassInspection
extends BaseInspection {
    public boolean ignoreAbstractClasses = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instance.variable.of.concrete.class.problem.descriptor", infos);
        if (string == null) {
            InstanceVariableOfConcreteClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("instance.variable.of.concrete.class.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAbstractClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableOfConcreteClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceVariableOfConcreteClassInspection", "buildErrorString"));
    }

    private class InstanceVariableOfConcreteClassVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableOfConcreteClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                InstanceVariableOfConcreteClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (field.hasModifierProperty("static")) {
                return;
            }
            PsiTypeElement typeElement = field.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement, InstanceVariableOfConcreteClassInspection.this.ignoreAbstractClasses)) {
                return;
            }
            String variableName = field.getName();
            this.registerError((PsiElement)typeElement, variableName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/abstraction/InstanceVariableOfConcreteClassInspection$InstanceVariableOfConcreteClassVisitor", "visitField"));
        }
    }
}

