/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class InterfaceMethodClashesWithObjectInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("interface.clashes.with.object.class.problem.descriptor", new Object[0]);
        if (string == null) {
            InterfaceMethodClashesWithObjectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InterfaceClashesWithObjectClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InterfaceMethodClashesWithObjectInspection", "buildErrorString"));
    }

    private static class InterfaceClashesWithObjectClassVisitor
    extends BaseInspectionVisitor {
        private InterfaceClashesWithObjectClassVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!method.getParameterList().isEmpty()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !aClass.isInterface()) {
                return;
            }
            String name2 = method.getName();
            if ("clone".equals(name2) && !(method.getReturnType() instanceof PsiClassType)) {
                this.registerMethodError(method, new Object[0]);
            } else if ("finalize".equals(name2) && !PsiType.VOID.equals((Object)method.getReturnType())) {
                this.registerMethodError(method, new Object[0]);
            }
        }
    }
}

