/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class AssignmentUsedAsConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.used.as.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            AssignmentUsedAsConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssignmentUsedAsConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentUsedAsConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection", "buildErrorString"));
    }

    private static class AssignmentUsedAsConditionVisitor
    extends BaseInspectionVisitor {
        private AssignmentUsedAsConditionVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                AssignmentUsedAsConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression2);
            if (expression2.getRExpression() == null || expression2.getOperationTokenType() != JavaTokenType.EQ || !PsiType.BOOLEAN.equals((Object)expression2.getType())) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            if (!PsiUtil.isCondition((PsiElement)expression2, (PsiElement)parent)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionVisitor", "visitAssignmentExpression"));
        }
    }

    private static class AssignmentUsedAsConditionFix
    extends InspectionGadgetsFix {
        private AssignmentUsedAsConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"=", "=="});
            if (string == null) {
                AssignmentUsedAsConditionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiAssignmentExpression expression2 = (PsiAssignmentExpression)descriptor.getPsiElement();
            PsiExpression leftExpression = expression2.getLExpression();
            PsiExpression rightExpression = expression2.getRExpression();
            assert (rightExpression != null);
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = commentTracker.text((PsiElement)leftExpression) + "==" + commentTracker.text((PsiElement)rightExpression);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionFix", "getFamilyName"));
        }
    }
}

