/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.bugs.NonFinalFieldsVisitor;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashCodeUsesNonFinalVariableInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonFinalFieldReferencedInHashCode";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.final.field.in.hashcode.problem.descriptor", new Object[0]);
        if (string == null) {
            HashCodeUsesNonFinalVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HashCodeUsesNonFinalVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/HashCodeUsesNonFinalVariableInspection", "buildErrorString"));
    }

    private static class HashCodeUsesNonFinalVariableVisitor
    extends NonFinalFieldsVisitor {
        private HashCodeUsesNonFinalVariableVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                HashCodeUsesNonFinalVariableVisitor.$$$reportNull$$$0(0);
            }
            if (MethodUtils.isHashCode(method)) {
                this.checkUsedNonFinalFields(method);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/bugs/HashCodeUsesNonFinalVariableInspection$HashCodeUsesNonFinalVariableVisitor", "visitMethod"));
        }
    }
}

