/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class MismatchedArrayReadWriteInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "MismatchedReadAndWriteOfArray";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean written = (Boolean)infos[0];
        if (written) {
            String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.write.not.read", new Object[0]);
            if (string == null) {
                MismatchedArrayReadWriteInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.read.not.write", new Object[0]);
        if (string == null) {
            MismatchedArrayReadWriteInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedArrayReadWriteVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection", "buildErrorString"));
    }

    private static class MismatchedArrayReadWriteVisitor
    extends BaseInspectionVisitor {
        private MismatchedArrayReadWriteVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MismatchedArrayReadWriteVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (!MismatchedArrayReadWriteVisitor.shouldCheckVariable((PsiVariable)field, (PsiElement)containingClass)) {
                return;
            }
            ArrayReadWriteVisitor visitor2 = new ArrayReadWriteVisitor((PsiVariable)field, !MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression(field.getInitializer()));
            containingClass.accept((PsiElementVisitor)visitor2);
            boolean written = visitor2.isWritten();
            if (!visitor2.isReferenced() || written == visitor2.isRead() || UnusedSymbolUtil.isImplicitWrite((PsiVariable)field)) {
                return;
            }
            this.registerFieldError(field, written);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                MismatchedArrayReadWriteVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!MismatchedArrayReadWriteVisitor.shouldCheckVariable((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            ArrayReadWriteVisitor visitor2 = new ArrayReadWriteVisitor((PsiVariable)variable, !MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression(variable.getInitializer()));
            codeBlock.accept((PsiElementVisitor)visitor2);
            boolean written = visitor2.isWritten();
            if (!visitor2.isReferenced() || written == visitor2.isRead()) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, written);
        }

        private static boolean shouldCheckVariable(PsiVariable variable, PsiElement context) {
            return context != null && variable.getType().getArrayDimensions() != 0 && !MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(variable.getInitializer());
        }

        static boolean mayBeAccessedElsewhere(PsiExpression expression2) {
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
                return false;
            }
            if (expression2 instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)expression2;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere((PsiExpression)arrayInitializer);
            }
            if (expression2 instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression2;
                for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
                    if (!MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(initializer)) continue;
                    return true;
                }
                return false;
            }
            if (expression2 instanceof PsiReferenceExpression) {
                return expression2.getType() instanceof PsiArrayType || TypeUtils.isJavaLangObject(expression2.getType());
            }
            if (expression2 instanceof PsiArrayAccessExpression) {
                return true;
            }
            if (expression2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
                return MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(typeCastExpression.getOperand());
            }
            if (expression2 instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
                return MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(conditionalExpression.getThenExpression()) || MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(conditionalExpression.getElseExpression());
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                PsiClass aClass;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return false;
                }
                String name2 = method.getName();
                return !("copyOf".equals(name2) || "copyOfRange".equals(name2) ? (aClass = method.getContainingClass()) != null && "java.util.Arrays".equals(aClass.getQualifiedName()) : "toArray".equals(name2) && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.util.Collection"));
            }
            return !(expression2 instanceof PsiLiteralExpression);
        }

        static boolean isZeroSizeArrayExpression(PsiExpression initializer) {
            if (initializer == null) {
                return true;
            }
            if (initializer instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)initializer;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return arrayInitializer == null || MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression((PsiExpression)arrayInitializer);
            }
            if (initializer instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
                PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
                return initializers.length == 0;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class ArrayReadWriteVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable myVariable;
            private boolean myWritten;
            private boolean myRead;
            private boolean myIsReferenced;

            ArrayReadWriteVisitor(@NotNull PsiVariable variable, boolean written) {
                if (variable == null) {
                    ArrayReadWriteVisitor.$$$reportNull$$$0(0);
                }
                this.myRead = false;
                this.myIsReferenced = false;
                this.myVariable = variable;
                this.myWritten = written;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (this.myWritten && this.myRead) {
                    return;
                }
                super.visitReferenceExpression(expression2);
                if (!expression2.isReferenceTo((PsiElement)this.myVariable)) {
                    return;
                }
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                    PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{PsiParenthesizedExpression.class});
                    if (parent instanceof PsiAssignmentExpression) {
                        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                        PsiExpression rhs = assignmentExpression.getRExpression();
                        if (MismatchedArrayReadWriteVisitor.mayBeAccessedElsewhere(rhs)) {
                            this.myWritten = true;
                            this.myRead = true;
                        } else if (!MismatchedArrayReadWriteVisitor.isZeroSizeArrayExpression(rhs)) {
                            this.myWritten = true;
                        }
                        if (!ExpressionUtils.isVoidContext((PsiExpression)assignmentExpression)) {
                            this.myWritten = true;
                            this.myRead = true;
                        }
                    }
                    return;
                }
                this.myIsReferenced = true;
                PsiElement parent = ArrayReadWriteVisitor.getParent((PsiElement)expression2);
                if (parent instanceof PsiArrayAccessExpression) {
                    int dimensions;
                    PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)parent;
                    parent = ArrayReadWriteVisitor.getParent(parent);
                    while (parent instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)parent).getArrayExpression() == arrayAccessExpression) {
                        arrayAccessExpression = (PsiArrayAccessExpression)parent;
                        parent = ArrayReadWriteVisitor.getParent(parent);
                    }
                    PsiType type2 = arrayAccessExpression.getType();
                    if (type2 != null && (dimensions = type2.getArrayDimensions()) > 0 && dimensions != this.myVariable.getType().getArrayDimensions()) {
                        this.myWritten = true;
                    }
                    if (PsiUtil.isAccessedForWriting((PsiExpression)arrayAccessExpression)) {
                        this.myWritten = true;
                    }
                    if (PsiUtil.isAccessedForReading((PsiExpression)arrayAccessExpression) && !this.goesToSameArray((PsiExpression)arrayAccessExpression) && (!PsiUtil.isAccessedForWriting((PsiExpression)arrayAccessExpression) || parent instanceof PsiExpression && !ExpressionUtils.isVoidContext((PsiExpression)parent))) {
                        this.myRead = true;
                    }
                } else if (parent instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
                    String name2 = referenceExpression.getReferenceName();
                    if ("clone".equals(name2) && referenceExpression.getParent() instanceof PsiMethodCallExpression) {
                        this.myRead = true;
                    }
                } else if (parent instanceof PsiForeachStatement) {
                    PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
                    PsiExpression iteratedValue2 = foreachStatement.getIteratedValue();
                    if (PsiTreeUtil.isAncestor((PsiElement)iteratedValue2, (PsiElement)expression2, (boolean)false)) {
                        this.myRead = true;
                    }
                } else if (parent instanceof PsiExpressionList) {
                    PsiClass aClass;
                    PsiMethodCallExpression methodCallExpression;
                    PsiMethod method;
                    PsiExpressionList expressionList = (PsiExpressionList)parent;
                    if ((parent = parent.getParent()) instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)parent).resolveMethod()) != null && (aClass = method.getContainingClass()) != null) {
                        String methodName = method.getName();
                        String qualifiedName = aClass.getQualifiedName();
                        if ("java.lang.System".equals(qualifiedName)) {
                            PsiExpression[] expressions2;
                            if ("arraycopy".equals(methodName) && (expressions2 = expressionList.getExpressions()).length == 5) {
                                if (PsiTreeUtil.isAncestor((PsiElement)expressions2[0], (PsiElement)expression2, (boolean)false)) {
                                    this.myRead = true;
                                    return;
                                }
                                if (PsiTreeUtil.isAncestor((PsiElement)expressions2[2], (PsiElement)expression2, (boolean)false)) {
                                    this.myWritten = true;
                                    return;
                                }
                            }
                        } else if ("java.util.Arrays".equals(qualifiedName)) {
                            if (("fill".equals(methodName) || "parallelPrefix".equals(methodName) || "parallelSetAll".equals(methodName) || "parallelSort".equals(methodName) || "setAll".equals(methodName) || "sort".equals(methodName)) && PsiTreeUtil.isAncestor((PsiElement)expressionList.getExpressions()[0], (PsiElement)expression2, (boolean)false)) {
                                this.myWritten = true;
                            } else {
                                this.myRead = true;
                            }
                            return;
                        }
                    }
                    this.myRead = true;
                    this.myWritten = true;
                } else {
                    this.myWritten = true;
                    this.myRead = true;
                }
            }

            private boolean goesToSameArray(PsiExpression expression2) {
                PsiExpression left;
                PsiExpression parent = (PsiExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent()), PsiExpression.class);
                if (parent == null) {
                    return false;
                }
                if (parent instanceof PsiPolyadicExpression || parent instanceof PsiUnaryExpression || parent instanceof PsiInstanceOfExpression || parent instanceof PsiConditionalExpression) {
                    return this.goesToSameArray(parent);
                }
                if (parent instanceof PsiAssignmentExpression && (left = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getLExpression())) instanceof PsiArrayAccessExpression && !PsiTreeUtil.isAncestor((PsiElement)left, (PsiElement)expression2, (boolean)false)) {
                    PsiExpression arrayExpression = ((PsiArrayAccessExpression)left).getArrayExpression();
                    return ExpressionUtils.isReferenceTo(arrayExpression, this.myVariable);
                }
                return false;
            }

            private static PsiElement getParent(PsiElement element) {
                PsiElement parent = element.getParent();
                while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression) {
                    parent = parent.getParent();
                }
                return parent;
            }

            public boolean isRead() {
                return this.myRead;
            }

            public boolean isWritten() {
                return this.myWritten;
            }

            public boolean isReferenced() {
                return this.myIsReferenced;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/bugs/MismatchedArrayReadWriteInspection$MismatchedArrayReadWriteVisitor$ArrayReadWriteVisitor", "<init>"));
            }
        }
    }
}

