/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class NewObjectEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inspection.new.object.equality.message", new Object[0]);
        if (string == null) {
            NewObjectEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NumberEqualityVisitor();
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = EqualityToEqualsFix.buildEqualityFixes((PsiBinaryExpression)infos[0]);
        if (inspectionGadgetsFixArray == null) {
            NewObjectEqualityInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/NewObjectEqualityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NumberEqualityVisitor
    extends BaseInspectionVisitor {
        private NumberEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                NumberEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            PsiExpression lhs = expression2.getLOperand();
            if (NumberEqualityVisitor.isNewObject(rhs) || NumberEqualityVisitor.isNewObject(lhs)) {
                this.registerError((PsiElement)expression2.getOperationSign(), expression2);
            }
        }

        @Contract(value="null -> false")
        private static boolean isNewObject(PsiExpression expression2) {
            if ((expression2 = ExpressionUtils.resolveExpression(expression2)) instanceof PsiNewExpression) {
                return true;
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)expression2);
                return ContractReturnValue.returnNew().equals(JavaMethodContractUtil.getNonFailingReturnValue(contracts2));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/NewObjectEqualityInspection$NumberEqualityVisitor", "visitBinaryExpression"));
        }
    }
}

