/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.GridBag;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ConstructorCountInspection
extends ClassMetricInspection {
    private static final int CONSTRUCTOR_COUNT_LIMIT = 5;
    public boolean ignoreDeprecatedConstructors = false;

    @NotNull
    public String getID() {
        return "ClassWithTooManyConstructors";
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("too.many.constructors.count.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        JLabel label = new JLabel(this.getConfigurationLabel());
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        CheckBox includeCheckBox = new CheckBox(InspectionGadgetsBundle.message("too.many.constructors.ignore.deprecated.option", new Object[0]), (InspectionProfileEntry)this, "ignoreDeprecatedConstructors");
        GridBag bag = new GridBag();
        bag.setDefaultInsets(0, 0, 0, 10);
        bag.setDefaultAnchor(17);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)label, bag.nextLine().next());
        panel2.add((Component)valueField, bag.next().weightx(1.0));
        panel2.add((Component)includeCheckBox, bag.nextLine().next().coverLine().weighty(1.0).anchor(18));
        return panel2;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("too.many.constructors.problem.descriptor", count);
        if (string == null) {
            ConstructorCountInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstructorCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classmetrics/ConstructorCountInspection", "buildErrorString"));
    }

    private class ConstructorCountVisitor
    extends BaseInspectionVisitor {
        private ConstructorCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int constructorCount;
            if (aClass == null) {
                ConstructorCountVisitor.$$$reportNull$$$0(0);
            }
            if ((constructorCount = this.calculateTotalConstructorCount(aClass)) <= ConstructorCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, constructorCount);
        }

        private int calculateTotalConstructorCount(PsiClass aClass) {
            PsiMethod[] constructors = aClass.getConstructors();
            if (!ConstructorCountInspection.this.ignoreDeprecatedConstructors) {
                return constructors.length;
            }
            int count = 0;
            for (PsiMethod constructor : constructors) {
                if (constructor.isDeprecated()) continue;
                ++count;
            }
            return count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ConstructorCountInspection$ConstructorCountVisitor", "visitClass"));
        }
    }
}

