/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicPackageDependencyInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        String errorString;
        if (refEntity == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        Set<RefPackage> dependencies = DependencyUtils.calculateTransitiveDependenciesForPackage(refPackage);
        Set<RefPackage> dependents = DependencyUtils.calculateTransitiveDependentsForPackage(refPackage);
        HashSet<RefPackage> mutualDependents = new HashSet<RefPackage>(dependencies);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        String packageName = refPackage.getQualifiedName();
        if (numMutualDependents == 1) {
            RefPackage[] packages = mutualDependents.toArray(new RefPackage[1]);
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.1.problem.descriptor", packageName, packages[0].getQualifiedName());
        } else if (numMutualDependents == 2) {
            RefPackage[] packages = mutualDependents.toArray(new RefPackage[2]);
            Arrays.sort(packages, RefEntityAlphabeticalComparator.getInstance());
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.2.problem.descriptor", packageName, packages[0].getQualifiedName(), packages[1].getQualifiedName());
        } else {
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.problem.descriptor", packageName, numMutualDependents);
        }
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalInspectionContext";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/dependency/CyclicPackageDependencyInspection";
        objectArray[2] = "checkElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

