/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EncapsulateVariableFix;
import org.jetbrains.annotations.NotNull;

public class ProtectedFieldInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return new EncapsulateVariableFix(field.getName());
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("protected.field.problem.descriptor", new Object[0]);
        if (string == null) {
            ProtectedFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/ProtectedFieldInspection", "buildErrorString"));
    }

    private static class ProtectedFieldVisitor
    extends BaseInspectionVisitor {
        private ProtectedFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                ProtectedFieldVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/encapsulation/ProtectedFieldInspection$ProtectedFieldVisitor", "visitField"));
        }
    }
}

